CARATTERISTICHE PRINCIPALI
- Funzionalità chiave: il componente Tag consente di visualizzare messaggi brevi e concisi al utente.
- Aspetti tecnici rilevanti: il componente utilizza la proprietà `tag.type` per cambiare l'icona condizionalmente.
- Caratteristiche di accessibilità: N.D.

VARIANTI
Il componente Tag è disponibile in diverse varianti, ciascuna con una descrizione e casi d'uso specifici:
### Variante 1: Default
Descrizione breve: il tag predefinito senza icona.
Casi d'uso: utilizzare quando non è necessaria un'icona specifica.

### Variante 2: Info
Descrizione breve: il tag con icona di informazione.
Casi d'uso: utilizzare per fornire informazioni aggiuntive al utente.

### Variante 3: Warning
Descrizione breve: il tag con icona di avvertimento.
Casi d'uso: utilizzare per segnalare potenziali problemi o errori.

### Variante 4: Danger
Descrizione breve: il tag con icona di pericolo.
Casi d'uso: utilizzare per indicare situazioni critiche o gravi.

BEST PRACTICES
- Raccomandazioni d'uso: utilizzare il componente Tag in combinazione con altri elementi UI per fornire un feedback chiaro e conciso al utente.
- Linee guida implementative: assicurarsi di utilizzare la proprietà `tag.type` correttamente per cambiare l'icona condizionalmente.
- Pratiche da evitare: non utilizzare il componente Tag come sostituto di altri elementi UI, ma piuttosto come complemento.

COMPONENTI CORRELATI
- Componenti associati: N.D.
- Relazioni con altri elementi: il componente Tag può essere utilizzato in combinazione con altri componenti UI per fornire un feedback più completo al utente.

## OVERVIEW
<div class="table-responsive">`import { TagComponent } from '@inail/internet-webkit/elements';`</div>
Componente custom utilizzato per creare tag che visualizzano vari messaggi e notifiche.

## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>tag</code></td>
      <td>
          `@Input() set tag(tag: Tag) {
		this._tag = tag;
		if (tag) {
			  switch (tag.type) {
			  	case TagTypes.WARNING:
			  		this.icon = 'i-warning';
			  		break;
			  	case TagTypes.SUCCESS:
			  		this.icon = 'i-check_circle';
			  		break;
			  	case TagTypes.INFO:
			  		this.icon = 'i-info_outline';
			  		break;
			  	case TagTypes.DANGER:
			  		this.icon = 'i-error';
			  		break;
			  	default:
			  		this.icon = undefined;
			  }
		}
}` <br />
          Input di tipo <a href="?path=/docs/resources-models-tag--docs">Tag</a> che imposta il tipo e crea il componente. <br />
		  
      </td>
    </tr>
  </tbody>
</table>
</div>