## CARATTERISTICHE PRINCIPALI

Le funzionalità chiave del Content Loader includono:

* La proprietà `loading` che consente di attivare o disattivare il loader
* La proprietà `size` che consente di scegliere la dimensione del loader (small, normal, big)
* La proprietà `spinnerMessage` che consente di personalizzare il messaggio di caricamento
* La proprietà `spinnerMessageEnd` che consente di personalizzare il messaggio di fine caricamento

Gli aspetti tecnici rilevanti includono:

* Il componente utilizza un'animazione CSS per visualizzare il loader
* Il componente è compatibile con i browser più comuni

Le caratteristiche di accessibilità includono:

* Il componente è accessibile ai screen reader
* Il componente è compatibile con le tecnologie assistive

## VARIANTI

Sono disponibili due varianti del Content Loader:

* **Variant 1: Caricamento in corso**
	+ Descrizione: Visualizza un messaggio di caricamento personalizzabile
	+ Casi d'uso: Utilizzare quando il contenuto sta essere caricato
* **Variant 2: Caricamento terminato**
	+ Descrizione: Visualizza un messaggio di fine caricamento personalizzabile
	+ Casi d'uso: Utilizzare quando il contenuto è stato caricato con successo

## BEST PRACTICES

Le raccomandazioni d'uso includono:

* Utilizzare il Content Loader per informare l'utente che il contenuto sta essere caricato
* Personalizzare il messaggio di caricamento e di fine caricamento per adattarlo alle esigenze dell'applicazione

Le linee guida implementative includono:

* Utilizzare le proprietà del componente per personalizzare il loader
* Assicurarsi che il componente sia accessibile ai screen reader e compatibile con le tecnologie assistive

Le pratiche da evitare includono:

* Non utilizzare il Content Loader come sostituto di un'esperienza utente più fluida
* Non utilizzare il componente in modo eccessivo o inappropriato

## COMPONENTI CORRELATI

Il Content Loader può essere utilizzato in combinazione con altri componenti per creare una esperienza utente più completa. Alcuni esempi di componenti correlati includono:

* **Button**: Utilizzare il Button per attivare o disattivare il loader
* **Modal**: Utilizzare il Modal per visualizzare un messaggio di caricamento personalizzabile

## OVERVIEW
<div class="table-responsive">`import { ContentLoaderComponent } from '@inail/internet-webkit/utils';`</div>


Il ContentLoaderComponent è un componente progettato per gestire in modo efficace il caricamento di contenuti dinamici all'interno di un'interfaccia utente.

Questo componente è particolarmente utile per migliorare l'esperienza utente durante l'attesa del caricamento di dati o contenuti da una fonte esterna. Può essere configurato per visualizzare animazioni di caricamento personalizzate, fornendo un feedback visivo che comunica chiaramente che il contenuto è in fase di caricamento.


## API
<div class="table-responsive">
  <table class="table">
	<thead> 
		<tr> 
			<th><strong>Campo</strong></th> 
			<th><strong>Descrizione</strong></th> 
		</tr> 
	</thead> 
	<tbody> 
		<tr> 
		   <td><code>loading</code></td> 
		   <td> `private _loading = false;`<br />
		   		`@Input()`<br />
				`@HostBinding('class.loading')`<br />
				`set loading(val: boolean) {}` <br /> 
				Questo input booleano controlla la visualizzazione dell'animazione di caricamento.<br />  
				<ul>
				<li>Quando è impostato su <code>true</code>, viene mostrato un cerchio di caricamento.</li>
				<li>Quando è impostato su <code>false</code>, il caricamento è disattivato (valore predefinito).</li>
				</ul>
				Utilizzando il decoratore <code>@HostBinding</code>, viene assegnata automaticamente la classe CSS <code>loading</code> agli elementi del DOM per abilitare la visualizzazione dell'animazione. </td> 
		</tr> 
		<tr> 
			<td><code>size</code></td> 
			<td> `@Input() size: 'small' | 'normal' | 'big' = 'normal';` <br /> Specifica la dimensione del caricamento: <code>small</code>, <code>normal</code> o <code>big</code>. Il valore predefinito è <code>normal</code>. </td> 
		</tr> 
		<tr> 
			<td><code>spinnerMessage</code>
			</td> 
			<td> `@Input() spinnerMessage = 'MESSAGES.SPINNER_LOADING';` <br /> Definisce il messaggio visualizzato durante il caricamento. Il valore predefinito è <code>'Caricamento in corso'</code>. <br /><code>Questo testo viene utilizzato per garantire l'accessibilità e il supporto ai lettori di schermo.</code>
			</td> 
		</tr> 
		<tr> 
			<td><code>spinnerMessageEnd</code>
			</td> 
			<td> `@Input() spinnerMessageEnd = 'MESSAGES.SPINNER_LOADING_END';` <br /> Definisce il messaggio visualizzato al termine del caricamento. Il valore predefinito è <code>'Caricamento terminato'</code>. <br /><code>Questo testo viene utilizzato per garantire l'accessibilità e il supporto ai lettori di schermo.</code>. 
			</td> 
		</tr> 
	</tbody> 
</table>
</div>
