## CARATTERISTICHE PRINCIPALI

Le caratteristiche chiave del componente Modal con Form includono:

- La possibilità di personalizzare la finestra di dialogo modale e il form al suo interno
- L'utilizzo di tecnologie web standard per garantire la compatibilità con diversi browser e dispositivi
- Le caratteristiche di accessibilità per garantire che il componente sia utilizzabile da utenti con disabilità

## VARIANTI

Il componente Modal con Form dispone di una variante principale:

- **Modal con Form**: questa è la variante standard del componente, che include un form con azioni personalizzabili.

Per ogni variante, i casi d'uso specifici includono:

- L'utilizzo del componente per creare una finestra di dialogo modale per l'inserimento di dati
- La personalizzazione delle azioni del form per adattarsi alle esigenze specifiche dell'applicazione

## BEST PRACTICES

Le raccomandazioni d'uso per il componente Modal con Form includono:

- Utilizzare il componente per creare finestre di dialogo modali che richiedono l'inserimento di dati
- Personalizzare le azioni del form per garantire una esperienza utente intuitiva e coerente
- Evitare di utilizzare il componente per scopi diversi da quelli previsti, come ad esempio la creazione di menu o altre interfacce utente complesse.

## COMPONENTI CORRELATI

Il componente Modal con Form è associato ai seguenti componenti:

- **Form**: il componente Form è un modulo web che consente di creare form personalizzabili.
- **Button**: il componente Button è un modulo web che consente di creare pulsanti personalizzabili.

Le relazioni tra questi componenti includono la possibilità di utilizzare il componente Modal con Form per creare finestre di dialogo modali contenenti form e pulsanti personalizzabili.

## OVERVIEW

<div class="table-responsive">`import { ModalComponent } from '@inail/intranet-webkit/modals';`</div>

Il componente ModalComponent è progettato per creare finestre modali personalizzabili e interattive all'interno di un'applicazione. Offre un'ampia gamma di opzioni per configurare titolo, contenuto, dimensione, azioni e comportamento, rendendolo ideale per notifiche, conferme e altri tipi di interazione con l'utente.

Il componente è altamente configurabile e supporta proprietà, eventi e opzioni per gestire scenari complessi, migliorando l'esperienza dell' utente e l'accessibilità

## API

<div class="table-responsive">
  <table class="table table-documentation">
    <thead>
       <tr>
         <th style="width: 20%"><strong>Campo</strong></th>
         <th style="width: 80%"><strong>Descrizione</strong></th>
       </tr>
     </thead>
     <tbody>
       <tr>
         <td><code>title</code></td>
         <td> <code>@Input() title!: string;</code><br /> Titolo della finestra modale. Visualizzato nella barra superiore del componente. </td>
       </tr>
       <tr>
         <td><code>id</code></td>
         <td> <code>@Input() id = '';</code><br /> Identificativo univoco per la finestra modale. Può essere utilizzato per riferirsi al componente in modo specifico. </td>
       </tr>
       <tr>
         <td><code>headerAction</code></td>
         <td> <code>@Input() headerAction!: ActionItem[];</code><br /> Azioni configurabili da mostrare nell'intestazione della finestra modale. Accetta un array di elementi di tipo <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a>. </td>
       </tr>
       <tr>
         <td><code>size</code></td>
         <td> <code>@Input() size: ModalSizeType = 'md';</code><br /> Dimensione della finestra modale. Valori supportati: <code>'sm'</code>, <code>'md'</code>, <code>'lg'</code>.<br /> Valore predefinito: <code>'md'</code>. </td>
       </tr>
       <tr>
         <td><code>buttons</code></td>
         <td> <code>@Input() buttons: any[] = buttons: any[] = [</code><br />
        <code>new ModalActionItem('BUTTON.CLOSE', () => {</code><br />
        <code>this.close();</code><br />
        <code>}),</code><br />
        <code>];</code><br /> Pulsanti configurabili visualizzati nel footer della finestra modale. Può includere azioni personalizzate, come chiudere la finestra o eseguire una funzione. Accetta un array di elementi di tipo <a href="?path=/docs/resources-models-modalactionitem--docs">ModalActionItem</a>.</td>
       </tr>
       <tr>
         <td><code>oneLastFocus</code></td>
         <td> <code>@Input() oneLastFocus!: boolean;</code><br /> Indica se un elemento specifico dovrebbe ricevere il focus dopo la chiusura della finestra modale. </td>
       </tr>
       <tr>
         <td><code>message</code></td>
         <td> Contenuto visualizzato nella modale. </td>
       </tr>
     </tbody>
</table>
</div>

 <br />
 <br />

<div class="table-responsive">
  <table class="table table-documentation">
   <thead>
     <tr>
       <th style="width: 20%"><strong>Event</strong></th>
       <th style="width: 80%"><strong>Descrizione</strong></th>
     </tr>
   </thead>
   <tbody>
     <tr>
       <td><code>onClose</code></td>
         <td> <code>@Output() onClose: EventEmitter&lt;any&gt; = new EventEmitter&lt;any&gt;();</code><br /> Evento emesso quando la finestra modale viene chiusa. </td>
      </tr>
  </tbody>
  </table>
</div>
