## CARATTERISTICHE PRINCIPALI

Funzionalità Chiave

* Il componente accetta un oggetto con proprietà chiave-valore come input
* La proprietà `propertyName` viene utilizzata per mostrare il nome della proprietà
* La proprietà `defaultValue` viene utilizzata per mostrare il valore predefinito della proprietà

Aspetti Tecnici Rilevanti

* Il componente utilizza una struttura di dati interna per memorizzare le coppie key-value
* La visualizzazione delle informazioni viene gestita tramite un template HTML personalizzabile

Caratteristiche di Accessibilità

N.D.

## VARIANTI
-------------

Il componente **Input Detail** dispone di diverse varianti di visualizzazione, ognuna con caratteristiche specifiche:

Variante 1: Default

* Mostra il nome della proprietà e il valore predefinito
* Utilizza un layout standard per la visualizzazione dei dati

Descrizione breve: Visualizzazione standard delle coppie key-value.

Variante 2: Dettagliata

* Mostra il nome della proprietà, il valore predefinito e una descrizione dettagliata del dato
* Utilizza un layout esteso per la visualizzazione dei dati

Descrizione breve: Visualizzazione dettagliata delle coppie key-value con descrizione aggiuntiva.

## BEST PRACTICES

Raccomandazioni d'Uso

* Utilizzare il componente **Input Detail** quando è necessario mostrare informazioni chiave-valore in modo chiaro e conciso.
* Personalizzare la visualizzazione dei dati utilizzando i template HTML forniti.

Linee Guida Implementative

* Assicurarsi di fornire un oggetto con proprietà chiave-valore valide come input per il componente.
* Utilizzare le proprietà `propertyName` e `defaultValue` per mostrare le informazioni corrette.

## COMPONENTI CORRELATI

Il componente **Input Detail** può essere utilizzato in combinazione con altri componenti di interfaccia utente per creare una esperienza utente più completa. Alcuni esempi di componenti correlati includono:

* **Form**: utilizzare il componente **Input Detail** all'interno di un form per mostrare informazioni chiave-valore relative ai dati dell'utente.
* **Tabella**: utilizzare il componente **Input Detail** per mostrare informazioni chiave-valore relative ai dati presenti in una tabella.

## OVERVIEW
<div class="table-responsive">`import { InputDetailComponent } from '@inail/intranet-webkit/elements';`</div>

Componente personalizzato utilizzato per visualizzare un'etichetta e un valore."

## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>label</code></td>
      <td>
        `@Input() set label(value: string) {}` <br />
        Campo di tipo stringa che imposta l'etichetta dell'InputDetail.
      </td>
    </tr>
    <tr>
      <td><code>extId</code></td>
      <td>
          `@Input('ext-id') extId: string = composeUniqueId('.');` <br />
          Id univoco aggiunto all'InputDetail.
      </td>
    </tr>
    <tr>
      <td><code>value</code></td>
      <td>
          `@Input('value') value: any;` <br />
          Imposta il valore visualizzato dall'InputDetail.
      </td>
    </tr>
    <tr>
      <td><code>size</code></td>
      <td>
          `@Input() set size(pipes: string | BootstrapSize) {}` <br />
         Campo che imposta le dimensioni del componente secondo il formato <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize</a> 
      </td>
    </tr>
  </tbody>
</table>
</div>