## CARATTERISTICHE PRINCIPALI

* Funzionalità chiave: il componente ActionComponent consente di creare azioni personalizzate e di associarle a eventi specifici.
* Aspetti tecnici rilevanti: il componente utilizza un sistema di gestione degli eventi per eseguire le azioni associate.
* Caratteristiche di accessibilità: il componente è progettato per essere accessibile da parte degli utenti con disabilità, in quanto rispetta gli standard di accessibilità web.

## VARIANTI

* Elenco e descrizione delle varianti disponibili:
 + Variante 1: azione predefinita ( Scarica file )
* Casi d'uso specifici per ogni variante:
 + Variante 1: utilizzare l'azione per scaricare un file da un server remoto.
* Breve descrizione per ogni variante:
 + Variante 1: il componente ActionComponent fornisce un pulsante "Scarica file" che consente all'utente di scaricare un file selezionato.

## BEST PRACTICES

* Raccomandazioni d'uso: utilizzare il componente ActionComponent per creare azioni personalizzate e associate a eventi specifici.
* Linee guida implementative: assicurarsi di rispettare gli standard di accessibilità web durante l'implementazione del componente.
* Pratiche da evitare: non utilizzare il componente per eseguire azioni che richiedono una conferma da parte dell'utente senza fornire un messaggio di conferma chiaro.

## COMPONENTI CORRELATI

* Componenti associati: il componente ActionComponent può essere utilizzato in combinazione con altri componenti, come ad esempio un componente di gestione dei file.
* Relazioni con altri elementi: il componente ActionComponent può essere utilizzato per eseguire azioni associate a eventi specifici, come ad esempio il clic su un pulsante.

## OVERVIEW
<div class="table-responsive">`import { ActionComponent } from '@inail/intranet-webkit/buttons';`</div>


L'ActionComponent è un componente progettato per rappresentare un'azione interattiva in un'interfaccia utente. È altamente personalizzabile e permette di specificare icone, titoli dinamici, classi aggiuntive e altre configurazioni.

L'ActionComponent è ideale per creare pulsanti o elementi interattivi che eseguono azioni specifiche e supportano l'uso di tooltip per migliorare l'esperienza utente. È particolarmente utile in contesti in cui le azioni sono associate a modelli o dati dinamici.


## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>action</code></td>
      <td> <code>`@Input() set action(action: ActionItem) {...} `</code><br /> Azione da rappresentare nel componente. Deve essere un oggetto di tipo <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a>.
      </td>
    </tr>
    <tr>
      <td><code>model</code></td>
      <td> <code>@Input() model!: BaseModel;</code><br /><a href="?path=/docs/resources-models-basemodel--docs">BaseModel</a> è un modello associato all'azione. Fornisce dati dinamici al componente, rendendolo contestualmente sensibile. </td>
    </tr>
    <tr>
      <td><code>onlyIcon</code></td>
      <td> <code>@Input() onlyIcon = false;</code><br />Booleano che indica se l'azione deve mostrare solo l'icona o anche il testo.<br /> Valore predefinito: <code>false</code>. </td>
    </tr>
    <tr>
      <td><code>disabled</code></td>
      <td> <code>@Input() disabled = false;</code><br /> Booleano che abilita o disabilita l'interattività del componente.<br /> Valore predefinito: <code>false</code>. </td>
    </tr>
    <tr>
      <td><code>dynamicTitle</code></td>
      <td> <code>@Input() dynamicTitle!: string | number;</code><br /> Titolo dinamico visualizzato nel componente. Può essere un testo o un valore numerico. </td>
    </tr>
    <tr>
      <td><code>extraClass</code></td>
      <td> <code>@Input() extraClass = '';</code><br /> Classe CSS aggiuntiva per personalizzare ulteriormente lo stile del componente.</td>
    </tr>
    <tr>
      <td><code>tooltipPlacement</code></td>
      <td> <code>@Input() tooltipPlacement: TooltipPlaceType = TooltipPlacementEnum.LEFT;</code><br /> Specifica la posizione del tooltip rispetto all'azione. Il valore predefinito è <code>LEFT</code>. 
      <br />
      <ul>
      <li><a href="?path=/docs/resources-models-tooltipplacetype--docs">TooltipPlaceType</a></li>
      <li><a href="?path=/docs/resources-models-tooltipplacementenum--docs">TooltipPlacementEnum</a></li>
      </ul> </td>
    </tr>
    <tr>
      <td><code>id</code></td>
      <td> <code>@Input() id: string = composeUniqueId('action');</code><br /> 
      Identificativo univoco generato automaticamente per il componente. È possibile sovrascriverlo fornendo un valore personalizzato. </td>
    </tr>
     <tr>
      <td><code>hideOrForceTabindex</code></td>
      <td> <code>@Input() hideOrForceTabindex: boolean | null;</code><br /> 
      Campo booleano che controlla la visibilità o l'impostazione forzata del tab index. </td>
    </tr>
  </tbody>
</table>
</div>