CARATTERISTICHE PRINCIPALI
- Funzionalità chiave: indica la fine della pagina
- Aspetti tecnici rilevanti: N.D.
- Caratteristiche di accessibilità: N.D.

VARIANTI
- Elenco e descrizione delle varianti disponibili:
  - Nessuna variante specifica è stata trovata, ma il componente può essere utilizzato in diverse situazioni per indicare la fine della pagina.
- Casi d'uso specifici per ogni variante:
  - Utilizzare il componente Content End per separare il contenuto principale della pagina dal footer o da altri elementi che seguono.
- Breve descrizione per ogni variante: N.D.

BEST PRACTICES
- Raccomandazioni d'uso: utilizzare il componente Content End per fornire una chiara struttura alla pagina e separare il contenuto principale dagli elementi che seguono.
- Linee guida implementative: posizionare il componente Content End prima del footer o di altri elementi che seguono il contenuto principale della pagina.
- Pratiche da evitare: non utilizzare il componente Content End in modo arbitrario o senza una chiara ragione.

COMPONENTI CORRELATI
- Componenti associati: N.D.
- Relazioni con altri elementi: il componente Content End è solitamente utilizzato in combinazione con il footer o altri elementi che seguono il contenuto principale della pagina.

## OVERVIEW
<div class="table-responsive">`import { ContentEndComponent } from '@inail/internet-webkit/page-sections';`</div>

Il componente ContentEndComponent rappresenta un elemento semplice e personalizzabile che visualizza un messaggio predefinito o specificato dall'utente. Questo componente può essere utilizzato per indicare la fine di una sezione di contenuto principale all'interno di un'applicazione Angular.

## API
<div class="table-responsive">
  <table class="table">
   <thead>
      <tr>
         <th><strong>Campo</strong></th>
         <th><strong>Descrizione</strong></th>
      </tr>
   </thead>
   <tbody>
      <tr>
         <td><code>message</code></td>
         <td>
            `@Input() message = 'MESSAGES.MAIN_CONTENT_END';` <br />
            Il controllo message rappresenta il testo che sarà mostrato all'interno del componente. È possibile passare una stringa personalizzata o una chiave di traduzione (ad esempio, per il supporto i18n).
         </td>
      </tr>
   </tbody>
</table>
</div>