## CARATTERISTICHE PRINCIPALI

Le funzionalità chiave del componente Box includono:

* La possibilità di personalizzare il titolo e la descrizione
* L'opzione per mostrare o nascondere il sottotitolo
* La possibilità di aggiungere un'icona personalizzata

Gli aspetti tecnici rilevanti del componente Box includono:

* Utilizzo di HTML e CSS per la struttura e lo stile
* Possibilità di utilizzare classi CSS personalizzate per modificare l'aspetto

Le caratteristiche di accessibilità del componente Box includono:

* Utilizzo di attributi ARIA per migliorare l'accessibilità per gli utenti con disabilità

## VARIANTI

Il componente Box dispone delle seguenti varianti:

* **Box**: la variante principale del componente
* **Box con icona**: variante che include un'icona personalizzata
* **Box con sottotitolo**: variante che include un sottotitolo

Per ogni variante, ci sono casi d'uso specifici:

* Utilizzare il componente Box per mostrare informazioni aggiuntive su una pagina web
* Utilizzare la variante con icona per aggiungere un elemento visivo al messaggio
* Utilizzare la variante con sottotitolo per fornire ulteriori dettagli sul contenuto

## BEST PRACTICES

Le raccomandazioni d'uso del componente Box includono:

* Utilizzare il componente in modo coerente all'interno di una pagina web
* Personalizzare l'aspetto del componente utilizzando classi CSS personalizzate
* Assicurarsi che il contenuto sia chiaro e conciso

Le linee guida implementative includono:

* Utilizzare HTML e CSS per la struttura e lo stile del componente
* Testare il componente per assicurarsi della sua accessibilità e usabilità

Pratiche da evitare:

* Non utilizzare il componente in modo eccessivo o ripetuto all'interno di una pagina web
* Non modificare l'aspetto del componente in modo non coerente con le linee guida dello stile

## COMPONENTI CORRELATI

Il componente Box è associato ai seguenti componenti:

* **Card**: componente utilizzato per mostrare informazioni in forma di carta
* **Alert**: componente utilizzato per mostrare messaggi di avviso o errore

Le relazioni con altri elementi includono:

* Utilizzo del componente Box all'interno di una pagina web per fornire informazioni aggiuntive
* Integrazione del componente Box con altri componenti per creare un'esperienza utente coerente.

## OVERVIEW
<div class="table-responsive">`import { BoxComponent } from '@inail/internet-webkit/elements';`</div>
<br />
Il componente BoxComponent visualizza una scheda (card) con titolo, descrizione, data e icona opzionali, supportando proiezione di contenuti personalizzati tramite ng-content. Utilizza la classe BootstrapSize per gestire le dimensioni e include eventi di clic tramite manageClick. 
È possibile mostrare o nascondere il sottotitolo con la proprietà showSubtitle.

## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Campo</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>title</code></td>
      <td>
        `@Input() title!: string;` <br />
        Input di tipo string che assegna il titolo al componente.
      </td>
    </tr>
    <tr>
      <td><code>description</code></td>
      <td>
          `@Input() description!: string;` <br />
          Input di tipo string che assegna la descrizione al componente.
      </td>
    </tr>
    <tr>
      <td><code>showSubtitle</code></td>
      <td>
          `@Input() showSubtitle = true;` <br />
          Input di tipo `Boolean` che decide se mostrare o meno il sottotitolo (description).
      </td>
    </tr>
    <tr>
      <td><code>icon</code></td>
      <td>
          `@Input() icon!: string;` <br />
          Input di tipo string che imposta un' icona al box. La stringa deve essere formattata  
          in modo da rispettare il seguente formato. <br /> `<span aria-hidden="true" class="icon i-{{ icon }}"></span>`
      </td>
    </tr>
    <tr>
      <td><code>titleBadge</code></td>
      <td>
          `@Input() titleBadge = '';` <br />
          Visualizza un badge o un'etichetta per il titolo, fornendo contesto o stato aggiuntivo.
      </td>
    </tr>
    <tr>
      <td><code>id</code></td>
      <td>
          `@Input() id = '';` <br />
          Imposta un ID di tipo String al componente.
      </td>
    </tr>
    <tr>
      <td><code>isFullHeight</code></td>
      <td>
          `@Input() isFullHeight = false;` <br />
          Input di tipo `boolean` che imposta il componente a piena altezza.
      </td>
    </tr>
    <tr>
      <td><code>isLight</code></td>
      <td>
          `@Input() isLight = false;` <br />
          Input di tipo `boolean` che abilita uno stile chiaro per il componente.
      </td>
    </tr>
  </tbody>
</table>
</div>

<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Event</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>manageClick</code></td>
      <td>
        `@Output() manageClick = new EventEmitter();` <br />
        `EventEmitter` tramite il quale è possibile gestire la logica del click sul box.
      </td>
    </tr>
  </tbody>
</table>
</div>