$(document).ready(function () {
    
var $input = $("input[data-input-type='multiselect']");
var $dropdown = $("#dropdownMenu");
var $checkboxes = $(".option-checkbox");
var currentIndex = -1;
var isOpening = false; // Flag per evitare selezione immediata


// Apri/chiudi il menu con Click o Enter
$input.on("click keydown", function (e) {
    if (e.type === "click" || e.key === "Enter") {
        e.preventDefault();
        if ($dropdown.is(":visible")) {
            $dropdown.hide();
        } else {
            $dropdown.show();
            currentIndex = 0;
            highlightOption();
            isOpening = true; // Imposta il flag per evitare selezione
            /* setTimeout(() => isOpening = false, 200);  //Reset dopo breve delay */
        }
    }
});

// Navigazione con le frecce
$(document).on("keydown", function (e) {
    if (!$dropdown.is(":visible")) return;

    if (e.key === "ArrowDown") {
        e.preventDefault();
        moveSelection(1);
    } else if (e.key === "ArrowUp") {
        e.preventDefault();
        moveSelection(-1);
    } else if ((e.key === "Enter" || e.key === " ") && !isOpening) {
        e.preventDefault();
        toggleSelection();
    } else if (e.key === "Escape") {
        $dropdown.hide();
    }
});

// Sposta la selezione in alto o in basso
function moveSelection(direction) {
    currentIndex = (currentIndex + direction + $checkboxes.length) % $checkboxes.length;
    highlightOption();
}

// Evidenzia e mette il focus sulla checkbox attuale
function highlightOption() {
    $checkboxes.eq(currentIndex).focus();
}

// Seleziona/deseleziona la checkbox attuale
function toggleSelection() {
    var $checkbox = $checkboxes.eq(currentIndex);
    $checkbox.prop("checked", !$checkbox.prop("checked")).trigger("change");
}

// Aggiorna l'input con le opzioni selezionate
function updateSelectedValues() {
    var selectedValues = $(".option-checkbox:checked").map(function () {
        return $(this).val();
    }).get().join(", ");
    $input.val(selectedValues);
}

// Chiudi il dropdown cliccando fuori
$(document).click(function (event) {
    if (!$(event.target).closest(".dropdown").length) {
        $dropdown.hide();
    }
});

// Aggiorna il valore dell'input quando cambia una checkbox
$(".option-checkbox").change(updateSelectedValues);

});
