## CARATTERISTICHE PRINCIPALI

*   **Funzionalità chiave**: 
    + Visualizzazione dinamica dei dati
    + Gestione delle righe e delle colonne
    + Filtro e ordinamento dei dati

*   **Aspetti tecnici rilevanti**:
    + Supporto per dispositivi mobili e desktop

*   **Caratteristiche di accessibilità**:
    + Conformità ai standard WCAG 2.1
    + Supporto per tecnologie assistive (ad esempio, lettori di schermo)

## VARIANTI


*   **Tabella Semplice**: Visualizzazione di base dei dati in forma tabellare

    * Casi d'uso specifici: Utilizzo come componente di base per la visualizzazione dei dati
    * Breve descrizione: Questa variante fornisce una visualizzazione di base dei dati in forma tabellare, senza funzionalità avanzate.

*   **Tabella Uno**: Visualizzazione di base dei dati in forma tabellare con la possibilità di eseguire l'ordinamento su alcune colonne. Offre inoltre la possibilità della paginazione.

    * Casi d'uso specifici: Utilizzo come componente di base per la visualizzazione dei dati con ordinamento e la necessità di paginare la tabella.
    * Breve descrizione: Questa variante fornisce una visualizzazione di base dei dati in forma tabellare e la possibilità di eseguire l'ordinamento su alcune colonne.

*   **Tabella con Accordion**: Visualizzazione dei dati con possibilità di espandere la riga. Inoltre offre la possibilità di fare l'ordinamento e la paginazione.

    * Casi d'uso specifici: Utilizzo per la gestione di righe con grandi quantità di dati.
    * Breve descrizione: Questa variante permette agli utenti di ottimizzare la visualizzazione dei dati.

*   **Tabella con Checkbox**: Visualizzazione dei dati con possibilità di selezione multipla di righe.

    * Casi d'uso specifici: Utilizzo per la selezione di righe multiple che richiedono la stessa azione.
    * Breve descrizione: Questa variante aggiunge funzionalità di gestione delle righe permettendo agli utenti operazioni massive.
    
*   **Tabella con Elementi di download**: Visualizzazione dei dati con possibilità di selezione eseguire il download di file.

    * Casi d'uso specifici: Utilizzo per il dowload dei file da una Tabella.
    * Breve descrizione: Questa variante aggiunge funzionalità di download dei file.
    
*   **Tabella con Icone e Notifiche**: Visualizzazione dei dati con possibilità di arricchire le righe con Icone per appresentare uno stato e riepilogare le notifiche.

    * Casi d'uso specifici: Utilizzo quando c'è la necessità di avere Icone e Notifiche che hanno impatto sulla visualizzazione dell'utente.
    * Breve descrizione: Questa variante aggiunge nuove modalità di visualizzazioni.    
    
*   **Tabella con Status**: Visualizzazione dei dati con possibilità di avere uno status di avanzamento relativo alle informazioni della riga. Inoltre ha la possibilità di avere un accordion per rappresentare meglio righe che hanno un numero di campi elevati.

    * Casi d'uso specifici: Utilizzo quando c'è la necessità di avere un avanzamento dello stato delle informazioni rappresentate dalla riga.
    * Breve descrizione: Questa variante aggiunge nuove modalità di visualizzazioni delle informazioni.  





## BEST PRACTICES

Utilizzare il componente per visualizzare grandi quantità di dati

*   **Raccomandazioni d'uso**:  Personalizzare la struttura e l'aspetto della tabella in base alle esigenze specifiche dell'applicazione
*   **Linee guida implementative**: Utilizzare tecnologie web moderne (HTML, CSS, JavaScript)
*   **Pratiche da evitare**: Non utilizzare il componente per visualizzare dati di piccole dimensioni o non complessi

## COMPONENTI CORRELATI

Il Componente di Selezione Multipla è correlato ai seguenti componenti:

*   Componente di filtro e ordinamento dei dati
*   Componente di gestione delle righe e delle colonne

## ACCESSIBILITA'
Usare le tabelle esclusivamente per dati tabellari, utilizzando gli attributi alt e caption, th, scope, tr e td; usare l'elemento `<caption>` per associare didascalie a tabelle di dati. Tutte le icone presenti nelle tabelle devono essere corredate di un testo alternativo sotto forma di tooltip accessibile sia con il mouse che da tastiera che ne descriva la funzionalità.

Tabelle con colonne ordinabili:
Si segnala un bug di accessbilità nella libreria datatables.js. Lo screen reader, interagendo con il pulsante di ordinamento, legge anche il `<title>` della pagina. Il focus sul pulsante viene quindi forzato tramite dataTablesEdit.js. Lo screen reader in alcuni casi ripete l'istruzione una seconda volta. Non è possibile correggere il bug in questa versione.

## CODICE
Per l'utilizzo di funzionalità complesse come l'ordinamento delle righe, la paginazione, la scelta del numero di elementi da visualizzare ed i filtri viene utilizzata la libreria JQuery DataTables. La relativa documentazione si trova a questo [link](https://datatables.net/).

Per un corretto funzionamento é necessario includere le librerie: dataTables.bootstrap.min.css, jquery.dataTables.min.js, dataTables.bootstrap.min.js e dataTablesEdit.js.
L'attivazione delle funzionalità e la definizione dei componenti nelle tabelle DataTables sono da impostare in dataTablesEdit.js.

La risoluzione per il comportamento responsive della TABELLA SEMPLICE RESPONSIVE ALTERNATIVA é fissata a 800px (punto di collasso). Per personalizzare tale valore é possibile modificare la query string relativa al tag `<table>` aggiungendo una nuova classe e sovrascrivendola con una nuova regola.