## CARATTERISTICHE PRINCIPALI
Le caratteristiche chiave della componente Pagina Non Trovata includono:

* Funzionalità di visualizzazione del messaggio di errore
* Possibilità di personalizzare il testo del messaggio di errore
* Aspetti tecnici rilevanti: la componente utilizza un meccanismo di rendering dinamico per visualizzare il messaggio di errore
* Caratteristiche di accessibilità: la componente è progettata per essere accessibile agli utenti con disabilità, rispettando gli standard di accessibilità web

## VARIANTI
La componente Pagina Non Trovata presenta le seguenti varianti:

* **Pagina non trovata**: visualizza un messaggio di errore generico quando una pagina non viene trovata
	+ Caso d'uso: errore 404
	+ Descrizione breve: messaggio di errore personalizzato per la pagina non trovata
* **Pagina non trovata dell'Inail**: visualizza un messaggio di errore personalizzato per la pagina non trovata dell'Inail
	+ Caso d'uso: errore 404 specifico per l'Inail
	+ Descrizione breve: messaggio di errore personalizzato per la pagina non trovata dell'Inail

## BEST PRACTICES
Le raccomandazioni d'uso per la componente Pagina Non Trovata includono:

* Utilizzare un testo chiaro e conciso per il messaggio di errore
* Personalizzare il testo del messaggio di errore in base alle esigenze specifiche dell'applicazione
* Rispettare gli standard di accessibilità web per garantire l'accessibilità della componente agli utenti con disabilità

## COMPONENTI CORRELATI
La componente Pagina Non Trovata è correlata ai seguenti componenti:

* Componente di errore generico
* Componente di accessibilità

## CARATTERISTICHE PRINCIPALI
Le caratteristiche principali della Navigation Bar includono:

* **Funzionalità chiave**: La possibilità di personalizzare la barra di navigazione e aggiungere o rimuovere elementi di navigazione in modo dinamico.
* **Aspetti tecnici rilevanti**: La Navigation Bar è stata progettata per essere utilizzata con diverse tecnologie web, tra cui HTML, CSS e JavaScript. È anche compatibile con diverse librerie e framework di sviluppo web.
* **Caratteristiche di accessibilità**: La Navigation Bar è stata progettata per essere accessibile agli utenti con disabilità, in conformità con le linee guida WCAG 2.1.

## VARIANTI
La Navigation Bar dispone di diverse varianti, ognuna delle quali offre una modalità di navigazione diversa:

* **Variante 1**: La variante predefinita della Navigation Bar, che offre una barra di navigazione orizzontale con elementi di navigazione personalizzabili.
* **Variante 2**: Una variante verticale della Navigation Bar, che offre una barra di navigazione laterale con elementi di navigazione personalizzabili.
* **Casi d'uso specifici per ogni variante**:
 + La Variante 1 è adatta per applicazioni web che richiedono una navigazione orizzontale e intuitiva.
 + La Variante 2 è adatta per applicazioni web che richiedono una navigazione verticale e più complessa.

## BEST PRACTICES
Le raccomandazioni d'uso per la Navigation Bar includono:

* **Raccomandazioni d'uso**: Utilizzare la Navigation Bar in modo coerente all'interno dell'applicazione, per fornire un'esperienza utente uniforme.
* **Linee guida implementative**: Seguire le linee guida di progettazione e sviluppo per garantire che la Navigation Bar sia accessibile e funzionale.
* **Pratiche da evitare**: Evitare di utilizzare la Navigation Bar in modo non conforme alle linee guida di progettazione e sviluppo, poiché ciò potrebbe compromettere l'accessibilità e la funzionalità dell'applicazione.

## COMPONENTI CORRELATI
La Navigation Bar è correlata ai seguenti componenti:

* **Componenti associati**: La Navigation Bar può essere utilizzata in combinazione con altri componenti, come ad esempio il menu contestuale o la barra degli strumenti.
* **Relazioni con altri elementi**: La Navigation Bar interagisce con altri elementi dell'applicazione, come ad esempio le pagine e i contenuti.

## OVERVIEW
<div class="table-responsive">`import { PageNotFoundComponent } from '@inail/internet-webkit/page-sections';`</div>

Il componente `PageNotFoundComponent` serve a segnalare all'utente che la pagina richiesta non è disponibile, fornendo un'interfaccia chiara e intuitiva per la gestione degli errori 404. È altamente configurabile, consentendo la personalizzazione del messaggio di errore in base alle esigenze specifiche dell'applicazione.

## API
Questo componente non ha controlli.