## CARATTERISTICHE PRINCIPALI

* Funzionalità chiave:
 + Visualizzazione dinamica del modulo all'interno della finestra modale
 + Gestione degli eventi di input e submit del modulo
* Aspetti tecnici rilevanti:
 + Utilizzo di HTML, CSS e JavaScript per la creazione e gestione del componente
 + Possibilità di integrare con librerie e framework di sviluppo web (ad esempio, Angular)
* Caratteristiche di accessibilità:
 + Supporto per gli standard di accessibilità web (WCAG 2.1)
 + Possibilità di personalizzare l'accessibilità del componente in base alle esigenze specifiche

## VARIANTI

* Elenco e descrizione delle varianti disponibili:
 + Modal con Form di base: la variante di default che fornisce un modulo all'interno di una finestra modale
 + Modal con Form personalizzato: consente di personalizzare le azioni disponibili e l'aspetto del componente
* Casi d'uso specifici per ogni variante:
 + Utilizzo della variante di base per la gestione dei dati in un'applicazione web
 + Utilizzo della variante personalizzata per creare un'esperienza utente più avanzata e personalizzabile

## BEST PRACTICES

* Raccomandazioni d'uso:
 + Utilizzare il componente Modal con Form per la gestione dei dati in modo efficiente e organizzato
 + Personalizzare le azioni disponibili e l'aspetto del componente in base alle esigenze specifiche
* Linee guida implementative:
 + Utilizzare HTML, CSS e JavaScript per la creazione e gestione del componente
 + Integrare il componente con librerie e framework di sviluppo web (ad esempio, Angular)
* Pratiche da evitare:
 + Non utilizzare il componente Modal con Form per la gestione dei dati in modo inefficiente o disorganizzato

## COMPONENTI CORRELATI

* Componenti associati:
 + Modulo
 + Finestra modale
* Relazioni con altri elementi:
 + Il componente Modal con Form può essere utilizzato in combinazione con altri componenti per creare un'esperienza utente più avanzata e personalizzabile

 ## OVERVIEW
 <div class="table-responsive">`import { ButtonComponent } from '@inail/internet-webkit/buttons';`</div>
 
 Il ModalComponent è un componente progettato per creare finestre modali personalizzabili e interattive all'interno di un'applicazione. Offre un'ampia gamma di opzioni per configurare titolo, contenuto, dimensione, azioni e comportamento, rendendolo ideale per notifiche, conferme e altri tipi di interazione con l'utente.
 
 Il componente è altamente configurabile e supporta proprietà, eventi e opzioni per gestire scenari complessi, migliorando l'esperienza utente e l'accessibilità
 
 
 ## API
<div class="table-responsive">
  <table class="table">
     <thead>
       <tr>
         <th><strong>Campo</strong></th>
         <th><strong>Descrizione</strong></th>
       </tr>
     </thead>
     <tbody>
       <tr>
         <td><code>title</code></td>
         <td> <code>@Input() title!: string;</code><br /> Titolo della finestra modale. Visualizzato nella barra superiore del componente. </td>
       </tr>
       <tr>
         <td><code>id</code></td>
         <td> <code>@Input() id = '';</code><br /> Identificativo univoco per la finestra modale. Può essere utilizzato per riferirsi al componente in modo specifico. </td>
       </tr>
       <tr>
         <td><code>headerAction</code></td>
         <td> <code>@Input() headerAction!: ActionItem[];</code><br /> Azioni configurabili da mostrare nell'intestazione della finestra modale. Accetta un array di elementi di tipo <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a>. </td>
       </tr>
       <tr>
         <td><code>size</code></td>
         <td> <code>@Input() size: ModalSizeType = 'md';</code><br /> Dimensione della finestra modale. Valori supportati: <code>'sm'</code>, <code>'md'</code>, <code>'lg'</code>.<br /> Valore predefinito: <code>'md'</code>. </td>
       </tr>
       <tr>
         <td><code>buttons</code></td>
         <td> <code>@Input() buttons: any[]=buttons: any[] = [</code><br />
        <code>new ModalActionItem('BUTTON.CLOSE', () => {</code><br />
        <code>this.close();</code><br />
        <code>}),</code><br />
    <code>];</code><br /> Pulsanti configurabili visualizzati nel footer della finestra modale. Possono includere azioni personalizzate, come chiudere la finestra o eseguire una funzione. Accetta un array di elementi di tipo <a href="?path=/docs/resources-models-modalactionitem--docs">ModalActionItem</a>.</td>
       </tr>
       <tr>
         <td><code>oneLastFocus</code></td>
         <td> <code>@Input() oneLastFocus!: boolean;</code><br /> Indica se un elemento specifico dovrebbe ricevere il focus dopo la chiusura della finestra modale. </td>
       </tr>
       <tr>
         <td><code>backdrop</code></td>
         <td> <code>@Input() backdrop = false;</code><br /> Indica se il clic sull'area di sfondo (backdrop) chiude la finestra modale. Valore predefinito: <code>false</code>. </td>
       </tr>
       <tr>
         <td><code>showButtonClose</code></td>
         <td> <code>@Input() showButtonClose = true;</code><br /> Determina se mostrare il pulsante di chiusura nella barra superiore della finestra modale.<br /> Valore predefinito: <code>true</code>. </td>
       </tr>
     </tbody>
   </table>
 </div>

 <br />
 <br />

<div class="table-responsive">
  <table class="table">
   <thead>
     <tr>
       <th><strong>Event</strong></th>
       <th><strong>Descrizione</strong></th>
     </tr>
   </thead>
   <tbody>
        <tr>
         <td><code>onClose</code></td>
         <td> <code>@Output() onClose: EventEmitter&lt;any&gt; = new EventEmitter&lt;any&gt;();</code><br /> Evento emesso quando la finestra modale viene chiusa. </td>
       </tr>
  </tbody>
  </table>
  </div>