## CARATTERISTICHE PRINCIPALI

Il componente Input Number Interval presenta le seguenti caratteristiche chiave:

* **Funzionalità di inserimento**: il componente consente all'utente di inserire un intervallo di numeri utilizzando due campi di input separati.
* **Personalizzazione dell'aspetto**: è possibile personalizzare l'aspetto del componente utilizzando classi CSS e attributi HTML.
* **Accessibilità**: il componente è progettato per essere accessibile agli utenti con disabilità, in conformità con le linee guida WCAG 2.1.

## VARIANTI
Il componente Input Number Interval presenta le seguenti varianti:

* **StoriesInput Number IntervalTest della descrizione del input number interval**: questa variante presenta un esempio di come utilizzare il componente per inserire un intervallo di numeri.
* **Number Interval Number Interval  Number Interval From  Number Interval To Need help? Contact support. Show code**: questa variante presenta un esempio di come utilizzare il componente per inserire un intervallo di numeri con etichette personalizzate.

## BEST PRACTICES
Per utilizzare al meglio il componente Input Number Interval, è consigliabile:

* Utilizzare classi CSS e attributi HTML per personalizzare l'aspetto del componente.
* Assicurarsi che il componente sia accessibile agli utenti con disabilità.
* Evitare di utilizzare il componente in contesti dove non è necessario inserire un intervallo di numeri.

## COMPONENTI CORRELATI
Il componente Input Number Interval può essere utilizzato in combinazione con altri componenti, come ad esempio:

* **Input Text**: per inserire testo libero.
* **Select**: per selezionare opzioni da un elenco.

## OVERVIEW
<div class="table-responsive">`import { InputNumberIntervalComponent } from '@inail/internet-webkit/form-controls';`</div>

Il componente Input Number Interval è progettato per gestire l'inserimento di un intervallo numerico tramite due campi di input separati. È particolarmente utile per applicazioni in cui è necessario specificare limiti numerici, come fasce di prezzo, età o altre misurazioni numeriche.

## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>fromLabel</code></td>
      <td>
        `@Input() fromLabel = 'INPUT.FROM';` <br />
        Etichetta per l'inizio dell'intervallo.
      </td>
    </tr>
     <tr>
      <td><code>toLabel</code></td>
      <td>
        `@Input() toLabel = 'INPUT.TO';` <br />
        Etichetta per la fine dell'intervallo.
      </td>
    </tr>
    <tr>
      <td><code>BaseInputComponent controls</code></td>
      <td>
        `class InputNumberComponent extends BaseInputComponent` <br />
        Fare riferimento a <a href="?path=/docs/resources-models-baseinputcomponent--docs">BaseInputComponent.</a>
      </td>
    </tr>
    <tr>
      <td><code>size</code></td>
      <td>
      `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
      La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
      </td>
    </tr>
  </tbody>
</table>
</div>