## CARATTERISTICHE PRINCIPALI
- Funzionalità Chiave

*   Il componente consente agli utenti di inserire testo mentre indica lo stato di caricamento.
*   È possibile personalizzare il messaggio di caricamento.

- Aspetti Tecnici Rilevanti

*   Il componente utilizza una combinazione di HTML, CSS e JavaScript per creare l'effetto di caricamento.
*   È compatibile con i principali browser web.

- Caratteristiche di Accessibilità

*   Il componente è accessibile tramite tastiera e supporta le tecnologie assistive.

## VARIANTI

Il componente Input Loading ha una variante disponibile:

*   **Test della descrizione del input loading INAIL**: questa variante fornisce un esempio di come utilizzare il componente per creare un'esperienza utente più interattiva.

- Casi d'Uso Specifici

*   Utilizzare il componente per indicare lo stato di caricamento durante l'inserimento di dati.
*   Personalizzare il messaggio di caricamento per adattarlo alle esigenze specifiche dell'applicazione.

## BEST PRACTICES

- Raccomandazioni d'Uso

*   Utilizzare il componente in combinazione con altri elementi di interfaccia utente per creare un'esperienza utente più fluida e interattiva.
*   Personalizzare il messaggio di caricamento per adattarlo alle esigenze specifiche dell'applicazione.

- Linee Guida Implementative

*   Utilizzare il componente in modo coerente all'interno dell'applicazione per garantire una coerenza visiva e funzionale.
*   Testare il componente con diversi browser e dispositivi per garantire la compatibilità.

## COMPONENTI CORRELATI

Il componente Input Loading può essere utilizzato in combinazione con altri elementi di interfaccia utente, come ad esempio:

*   **Button**: utilizzare il componente Button per creare un'esperienza utente più interattiva e fluida.
*   **Form**: utilizzare il componente Form per creare un modulo di inserimento dati che indica lo stato di caricamento.

## OVERVIEW
<div class="table-responsive">`import { InputLoadingComponent } from '@inail/intranet-webkit/utils';`</div>

Il componente InputLoadingComponent viene utilizzato per indicare visivamente lo stato di caricamento di un campo di input. Supporta personalizzazioni tramite le proprietà disponibili, consentendo di adattarlo a diversi scenari di utilizzo.

## API
<div class="table-responsive">
  <table class="table table-documentation">
   <thead>
      <tr>
         <th><strong>Campo</strong></th>
         <th><strong>Descrizione</strong></th>
      </tr>
   </thead>
   <tbody>
      <tr>
         <td><code>loading</code></td>
         <td>
            `@Input() loading = false;` <br />
            Valore booleano che attiva o disattiva lo stato di caricamento. 
         </td>
      </tr>
   </tbody>
</table>
</div>