## CARATTERISTICHE PRINCIPALI
*   Funzionalità chiave:
    *   Calendario interattivo per la selezione di date
    *   Formato di visualizzazione personalizzabile della data
*   Aspetti tecnici rilevanti:
    *   Utilizza una libreria JavaScript per gestire il calendario
    *   Supporta la personalizzazione del formato di visualizzazione della data tramite opzioni di configurazione
*   Caratteristiche di accessibilità:
    *   Il componente è progettato per essere utilizzato da utenti con disabilità, con supporto per tastiera e tecnologie assistive

## VARIANTI
Il componente Data Picker ha due varianti:

### Variante 1: Date
*   Descrizione: Questa variante visualizza un calendario interattivo per la selezione di una data.
*   Caso d'uso specifico: Utilizzare questa variante quando si desidera consentire agli utenti di selezionare una sola data.
*   Breve descrizione: Seleziona una data dal calendario.

### Variante 2: Test della descrizione del input date INAIL
*   Descrizione: Questa variante visualizza un campo di testo per l'inserimento di una data.
*   Caso d'uso specifico: Utilizzare questa variante quando si desidera consentire agli utenti di inserire manualmente una data.
*   Breve descrizione: Inserisci la data nel formato richiesto.

## BEST PRACTICES
*   Raccomandazioni d'uso:
    *   Utilizzare il componente Data Picker quando è necessario consentire agli utenti di selezionare una data.
    *   Personalizzare il formato di visualizzazione della data in base alle esigenze dell'applicazione.
*   Linee guida implementative:
    *   Utilizzare la libreria JavaScript fornita per gestire il calendario.
    *   Configurare le opzioni di personalizzazione del formato di visualizzazione della data.
*   Pratiche da evitare:
    *   Non utilizzare il componente Data Picker quando non è necessario selezionare una data.

## COMPONENTI CORRELATI
Il componente Data Picker può essere utilizzato in combinazione con altri componenti per creare un'interfaccia utente completa. Ad esempio:

*   Componente Time Picker: consente agli utenti di selezionare un'ora.
*   Componente Date Range Picker: consente agli utenti di selezionare un intervallo di date.

Note:
Il componente Data Picker è progettato per essere utilizzato in una varietà di contesti e può essere personalizzato per adattarsi alle esigenze specifiche dell'applicazione.

## OVERVIEW
<div class="table-responsive">`import { InputDateComponent } from '@inail/internet-webkit/form-controls';`</div>
Questo componente è progettato per gestire l'input della data con proprietà personalizzabili.


## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>externalClass</code></td>
      <td>
        `@Input() externalClass = '';` <br />
        Classe CSS per lo stile personalizzato del componente.
      </td>
    </tr>
    <tr>
      <td><code>format</code></td>
      <td>
        `@Input() format = 'dd/MM/yyyy';` <br />
        Definisce il formato di output della data.
      </td>
    </tr>
     <tr>
      <td><code>inline</code></td>
      <td>
        `@Input() inline!: boolean;` <br />
        Determina se il selettore data viene visualizzato in linea o come finestra popup modale.
      </td>
    </tr>
    <tr>
      <td><code>regex</code></td>
      <td>
        `@Input() regex!: RegExp | string | string[];` <br />
        Modello regex per convalidare l'input della data.
       <ul>
            <li>
              Se il valore è un oggetto `RegExp`, significa che si sta passando un' espressione regolare JavaScript. Le espressioni regolari sono utilizzate per cercare e fare il matching di pattern all'interno di stringhe.
              `regex = /^[a-zA-Z]+$/;`
            </li>
            <li>
              Se il valore è una stringa, questa verrà trattata come una rappresentazione di un pattern. Quando la stringa viene utilizzata come regex, viene convertita internamente in una `RegExp` per eseguire operazioni di matching. 
              `regex = "^abc";`
            </li>
             <li>
              Se il valore è un array di stringhe, ciascun elemento dell'array rappresenta un pattern di stringa da utilizzare separatamente per il matching.
              `regex = ["^abc", "xyz$"];`
            </li>
       </ul>  
      </td>
    </tr>
    <tr>
      <td><code>BaseInputComponent controls</code></td>
      <td>
        `class InputComboboxComponent extends BaseInputComponent` <br />
        Fare riferimento a <a href="?path=/docs/resources-models-baseinputcomponent--docs">BaseInputComponent</a>
      </td>
    </tr>
    <tr>
      <td><code>size</code></td>
      <td>
      `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
      La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
      </td>
    </tr>
  </tbody>
</table>
</div>