## CARATTERISTICHE PRINCIPALI
Le caratteristiche principali del Pannello Espandibile includono:

* **Funzionalità chiave**: il componente è dotato di un bottone che consente di espandere o comprimere il contenuto.
* **Aspetti tecnici rilevanti**: il componente utilizza la proprietà `isOpen` per gestire lo stato del pannello e la proprietà `elementSizes` per personalizzare le dimensioni degli elementi interni.
* **Caratteristiche di accessibilità**: il componente è progettato per essere accessibile agli utenti con disabilità, grazie alla presenza di attributi ARIA e alla possibilità di navigazione tramite tastiera.

## VARIANTI
Le varianti disponibili del Pannello Espandibile includono:

* **Storia base**: la variante di base del pannello, che include un titolo e un contenuto espandibile.
* **Variante con azioni**: una variante del pannello che include un elenco di azioni aggiuntive.

Casi d'uso specifici per ogni variante:

* La storia base è ideale per la visualizzazione di informazioni supplementari in spazi limitati.
* La variante con azioni è utile quando si desidera fornire all'utente opzioni aggiuntive per interagire con il contenuto.

Breve descrizione per ogni variante:

* Storia base: "Un pannello espandibile di base che consente di visualizzare informazioni supplementari."
* Variante con azioni: "Un pannello espandibile che include un elenco di azioni aggiuntive per interagire con il contenuto."

## BEST PRACTICES
Le raccomandazioni d'uso del Pannello Espandibile includono:

* Utilizzare il componente in spazi limitati dove è necessario visualizzare informazioni supplementari.
* Personalizzare l'aspetto e il comportamento del pannello per adattarlo alle esigenze dell'applicazione.
* Utilizzare la proprietà `isOpen` per gestire lo stato del pannello e la proprietà `elementSizes` per personalizzare le dimensioni degli elementi interni.

Le linee guida implementative includono:

* Utilizzare il componente come parte di una interfaccia utente più ampia.
* Gestire gli eventi di espansione e compressione del pannello per aggiornare la visualizzazione dei contenuti.

Pratiche da evitare:

* Non utilizzare il componente in spazi troppo piccoli, poiché ciò potrebbe rendere difficile la navigazione e la lettura dei contenuti.
* Evitare di sovraccaricare il pannello con troppe informazioni, poiché ciò potrebbe renderlo difficile da usare.

## COMPONENTI CORRELATI
Il Pannello Espandibile è correlato ai seguenti componenti:

* **Pulsante**: il componente utilizzato per espandere e comprimere il contenuto del pannello.
* **Elenco**: il componente utilizzato per visualizzare le azioni aggiuntive nella variante con azioni.

Le relazioni con altri elementi includono:

* Il Pannello Espandibile può essere utilizzato all'interno di una interfaccia utente più ampia, come ad esempio un modulo o una finestra di dialogo.
* Il componente può essere personalizzato per adattarsi alle esigenze dell'applicazione e integrato con altri componenti per creare una soluzione completa.

## OVERVIEW
<div class="table-responsive">
  `import { ExpandablePanelComponent } from "@inail/internet-webkit/accordions";` <br />
</div>
Componente che si usa per creare pannelli espandibili. Si usa non come componente standalone, ma come Angular Directive di un elemento `<div>`, dato che il `selector` nel componente della libreria è 
<div class="table-responsive">
  `selector: 'div [data-inail-expandable-panel]'`
</div>

## API
<div class="table-responsive">
  <table class="table">
    <thead>
      <tr>
        <th style="width: 20%"><strong>Campo</strong></th>
        <th style="width: 80%"><strong>Descrizione</strong></th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><code>id</code></td>
        <td>
          `@Input() id = composeUniqueId('panel');` <br />
          ID dell' expandable panel.
        </td>
      </tr>
      <tr>
        <td><code>accordion</code></td>
        <td>
          	@Input() accordion!: TemplateRef<any> | null; <br />
            Oggetto di tipo TemplateRef che si fa render nel panel quando isBox=false.
        </td>
      </tr>
      <tr>
        <td><code>panelTitle</code></td>
        <td>
          	`@Input('panel-title') panelTitle!: string;` <br />
            Titolo del panel.
        </td>
      </tr>
      <tr>
        <td><code>panelContent</code></td>
        <td>
          	@Input() panelContent!: `TemplateRef<any>`; <br />
            Oggetto di tipo TemplateRef che si fa render come una sezione extra nel panel quando e  valorizzato. Valorizzazione facoltativa.
        </td>
      </tr>
      <tr>
        <td><code>actions</code></td>
        <td>
          	`@Input() actions: ActionItem[] = [];` <br />
            Array di <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a> valorizza il  [actions] input di un `<inail-actions-dropdown>` al interno del HTML del componente.
        </td>
      </tr>
      <tr>
        <td><code>model</code></td>
        <td>
          	`@Input() model: any;` <br />
            Oggetto di tipo <a href="?path=/docs/resources-models-basemodel--docs">BaseModel</a> che  valorizza il [model] input al interno del HTML ExpandablePanel.
        </td>
      </tr>
      <tr>
        <td><code>editMode</code></td>
        <td>
          	`@Input() editMode` <br />
            Input che quando valorizzato, si mostra un inail-button con isLink a true,che naviga a step.  editMode se tipo number, o editMode(id) se tipo Function.
        </td>
      </tr>
      <tr>
        <td><code>isBox</code></td>
        <td>
          	`@Input() set isBox(val: boolean) {}` <br />
            Booleano che rende il panel non espandibile quando è impostato su `true`.
        </td>
      </tr>
      <tr>
        <td><code>elementSizes</code></td>
        <td>
  `@Input() set elementSizes(s: ExpandablePanelElementSizes) {}` <br />
            Oggetto di tipo <a href="?path=/docs/  resources-models-expandablepanelelementsizes--docs">ExpandablePanelElementSizes</a> che   assegna le dimensioni Bootstrap agli elementi interni.
        </td>
      </tr>
      <tr>
        <td><code>isOpen</code></td>
        <td>
  `@Input() set isOpen(v: boolean) {}` <br />
            Valore booleano che gestisce la apertura/chiusura del panel.
        </td>
      </tr>
    </tbody>
  </table>
</div>

<div class="table-responsive">
  <table class="table">
    <thead>
  	<tr>
  	  <th style="width: 20%"><strong>Event</strong></th>
  	  <th style="width: 80%"><strong>Descrizione</strong></th>
  	</tr>
    </thead>
    <tbody>
      <tr>
        <td><code>toggle</code></td>
        <td>
  `@Output() toggle = new EventEmitter<boolean>();` <br />
     Un `EventEmitter` che emette un booleano per gestire l'apertura/chiusura dell' `ExpandablePanel`.  L'Evento viene gestito internalmente dall' `ExpandablePanel` component tramite la funzione  `utilityToggle()`.
    `utilityToggle(forceValue?: boolean) {
        if (!this.isBox) {
        	this._isOpen = forceValue == null ? !this.isOpen : forceValue;
        	this.toggle.emit(this.isOpen);
        }
  }`
        </td>
      </tr>
    </tbody>
  </table>
</div>