## CARATTERISTICHE PRINCIPALI

Le caratteristiche chiave del componente Progress Bar sono:

* **Funzionalità**: il componente può essere utilizzato per visualizzare lo stato di avanzamento di un processo o un'attività
* **Aspetti tecnici rilevanti**: il componente utilizza la proprietà `percent` per impostare la percentuale di completamento e la proprietà `status` per impostare lo stato del processo (ad esempio, "success", "error", ecc.)
* **Caratteristiche di accessibilità**: il componente è progettato per essere accessibile e utilizzabile da utenti con disabilità

## VARIANTI

Il componente Progress Bar dispone delle seguenti varianti:

* **PROGRESS_0**: rappresenta lo stato iniziale della barra di progresso (0%)
* **PROGRESS_25**: rappresenta la barra di progresso al 25%
* **PROGRESS_50**: rappresenta la barra di progresso al 50%
* **PROGRESS_75**: rappresenta la barra di progresso al 75%
* **PROGRESS_100_SUCCESS**: rappresenta la barra di progresso al 100% con stato "success"
* **PROGRESS_100_ERROR**: rappresenta la barra di progresso al 100% con stato "error"

Ciascuna variante ha un caso d'uso specifico e può essere utilizzata per rappresentare diversi stati del processo.

## BEST PRACTICES

Per utilizzare il componente Progress Bar in modo efficace, è consigliabile:

* Utilizzare la proprietà `percent` per impostare la percentuale di completamento
* Utilizzare la proprietà `status` per impostare lo stato del processo
* Personalizzare la barra di progresso con diverse opzioni (ad esempio, colore, dimensioni, ecc.)
* Evitare di utilizzare il componente Progress Bar per rappresentare stati non rilevanti o non significativi

## COMPONENTI CORRELATI

Il componente Progress Bar può essere utilizzato in combinazione con altri componenti per creare un'esperienza utente più completa. Alcuni esempi di componenti correlati includono:

* **Button**: può essere utilizzato per avviare o interrompere il processo rappresentato dalla barra di progresso
* **Label**: può essere utilizzato per fornire ulteriori informazioni sullo stato del processo

N.D.

## OVERVIEW
<div class="table-responsive">`import { ProgressBarComponent } from '@inail/internet-webkit/elements';`</div>
Il componente ProgressBarComponent visualizza una barra di avanzamento dinamica, configurabile tramite l'input percent, con opzioni per lo stato (error, success, warning) e una classe di avanzamento personalizzata. Supporta la dimensione tramite la classe BootstrapSize e aggiorna la visualizzazione quando cambiano percent o status.

## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Campo</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>label</code></td>
      <td>
          `@Input() label!: string;` <br />
          Campo di tipo `string` che imposta l'etichetta del ProgressBar.
      </td>
    </tr>
    <tr>
      <td><code>percent</code></td>
      <td>
          `@Input() percent!: number;` <br />
          Campo di tipo numerico che imposta la percentuale di completamento mostrata dal componente.
      </td>
    </tr>
    <tr>
      <td><code>status</code></td>
      <td>
          `@Input() status: undefined | 'error' | 'success' | 'warning';` <br />
          Campo che definisce lo stato della ProgressBar e cambia il colore di conseguenza.
      </td>
    </tr>
    <tr>
      <td><code>classProgress</code></td>
      <td>
          `@Input() classProgress!: ProgressBarPercent;` <br />
          Campo di tipo `ProgressBarPercent` che imposta il modo di visualizzazione del ProgressBar in base a constanti predefinite nella classe custom `ProgressBarPercent`. <br />
          `class ProgressBarPercent {
	public static PROGRESS_0 = new ProgressBarPercent(0);
	public static PROGRESS_25 = new ProgressBarPercent(25);
	public static PROGRESS_50 = new ProgressBarPercent(50);
	public static PROGRESS_75 = new ProgressBarPercent(75);
	public static PROGRESS_100_SUCCESS = new ProgressBarPercent(100, {status: 'success'});
	public static PROGRESS_100_ERROR = new ProgressBarPercent(100, {status: 'error'});

	public className: string;
	public success: boolean = false;

	public constructor(public value: number, opt?: { status?: 'error' | 'warning' | 'success', className?: string }) {
		        if (!opt || !opt.className) {
		        	this.className = 'bg-primary';
		        } else {
		        	this.className = opt.className;
		        }

		        if (opt && opt.status) {
		        	switch (opt.status) {
		        		case 'success':
		        			this.className = 'bg-success';
		        			break;
		        		case 'error':
		        			this.className = 'bg-danger';
		        			break;
		        		case 'warning':
		        			this.className = 'bg-warning';
		        			break;
		        	}
		        }
	}
}`
      </td>
    </tr>
    <tr>
      <td><code>size</code></td>
      <td>
        `@Input()set size(pipes: string | BootstrapSize) {}` <br />
        Campo che imposta le dimensioni <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize</a> al componente.
      </td>
    </tr>
  </tbody>
</table>
</div>