## CARATTERISTICHE PRINCIPALI
Le funzionalità chiave del componente Text Area includono:

* La possibilità di personalizzare la lunghezza massima del testo
* La gestione degli eventi di input per validare e formattare il testo inserito
* La compatibilità con diverse tecnologie di accessibilità

Gli aspetti tecnici rilevanti includono:

* La gestione della proprietà "propertyName" per impostare la descrizione del componente
* L'utilizzo di classi CSS per personalizzare l'aspetto e il comportamento del componente

Le caratteristiche di accessibilità includono:

* La possibilità di utilizzare attributi ARIA per migliorare l'accessibilità per gli utenti con disabilità

## VARIANTI
Sono disponibili le seguenti varianti del componente Text Area:

* **Test della descrizione del text area**: una variante che include una descrizione dettagliata del componente
* **INAIL Text Area**: una variante personalizzata per l'utilizzo in contesti specifici

Per ogni variante, sono disponibili casi d'uso specifici e brevi descrizioni:

* **Test della descrizione del text area**: utilizzare questo componente quando è necessario fornire una descrizione dettagliata dell'elemento di input
* **INAIL Text Area**: utilizzare questo componente in contesti dove è richiesta una personalizzazione specifica

## BEST PRACTICES
Le raccomandazioni d'uso per il componente Text Area includono:

* Utilizzare il componente in contesti dove è necessario inserire testo libero
* Personalizzare la lunghezza massima del testo per adattarsi alle esigenze specifiche dell'applicazione
* Utilizzare attributi ARIA per migliorare l'accessibilità

Le linee guida implementative includono:

* Utilizzare classi CSS per personalizzare l'aspetto e il comportamento del componente
* Gestire gli eventi di input per validare e formattare il testo inserito

Le pratiche da evitare includono:

* Non utilizzare il componente in contesti dove è richiesto un input di tipo diverso (ad esempio, selezione di opzioni)

## COMPONENTI CORRELATI
Il componente Text Area può essere utilizzato in combinazione con altri componenti per creare forme complesse e interattive. Alcuni esempi di componenti correlati includono:

* Componenti di input (ad esempio, campi di testo, selezioni di opzioni)
* Componenti di gestione del flusso di lavoro (ad esempio, pulsanti di invio, link di navigazione)

## OVERVIEW
<div class="table-responsive">`import { TextAreaComponent } from '@inail/intranet-webkit/form-controls';`</div>

Il componente TextArea è progettato per offrire un modo semplice e intuitivo per consentire agli utenti di inserire testo di lunghezza variabile all'interno di un'interfaccia utente. È ideale per raccogliere input più estesi, come commenti, descrizioni o messaggi.


## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>maxLength</code></td>
      <td>
        `@Input() maxLength = 300;` <br />
        Numero massimo di caratteri consentito nell'area di testo.
      </td>
    </tr>
    <tr>
      <td><code>rows</code></td>
      <td>
        `@Input() rows = 5;` <br />
        Numero di righe visibili nell'area di testo.
      </td>
    </tr>
    <tr>
      <td><code>BaseInputComponent controls</code></td>
      <td>
        `class TextAreaComponent extends BaseInputComponent` <br />
        Fare riferimento a <a href="?path=/docs/resources-models-baseinputcomponent--docs">BaseInputComponent.</a>
      </td>
    </tr>
  <tr>
    <td><code>size</code></td>
    <td>
    `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
    La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
    </td>
  </tr>
  </tbody>
</table>
</div>