## CARATTERISTICHE PRINCIPALI
Funzionalità chiave:

* Il componente Input può essere configurato per accettare diversi tipi di dati (ad esempio, testo, numeri, email, ecc.)
* Può essere utilizzato con diverse proprietà CSS per personalizzare l'aspetto e il comportamento

Aspetti tecnici rilevanti:

* Il componente Input è un elemento HTML standard
* Può essere integrato con altri componenti per creare form complessi

Caratteristiche di accessibilità:

* Il componente Input supporta gli attributi ARIA per migliorare l'accessibilità per utenti con disabilità
* Può essere configurato per rispettare le linee guida WCAG 2.1

## VARIANTI
Elenco e descrizione delle varianti disponibili:

* Test della descrizione del input INAIL: una variante che include una descrizione dettagliata dell'input
* InputNeed help?: una variante che include un messaggio di aiuto per l'utente

Casi d'uso specifici per ogni variante:

* La prima variante può essere utilizzata quando si desidera fornire ulteriori informazioni sull'input all'utente
* La seconda variante può essere utilizzata quando si desidera offrire supporto aggiuntivo all'utente durante l'inserimento dei dati

Breve descrizione per ogni variante:

* Test della descrizione del input INAIL: una variante che fornisce ulteriori informazioni sull'input
* InputNeed help?: una variante che offre supporto aggiuntivo all'utente

## BEST PRACTICES
Raccomandazioni d'uso:

* Utilizzare il componente Input in contesti in cui si desidera raccogliere dati dall'utente
* Configurare le proprietà del componente per rispettare le linee guida WCAG 2.1

Linee guida implementative:

* Utilizzare gli attributi ARIA per migliorare l'accessibilità
* Testare il componente con diversi dispositivi e browser per garantire la compatibilità

Pratiche da evitare:

* Non utilizzare il componente Input come sostituto di altri elementi di interfaccia utente (ad esempio, pulsanti o link)

## COMPONENTI CORRELATI
Componenti associati:

* Form: un componente che può essere utilizzato per creare form complessi
* Label: un componente che può essere utilizzato per fornire etichette descrittive per gli input

Relazioni con altri elementi:

* Il componente Input può essere utilizzato all'interno di un form per raccogliere dati dall'utente

## OVERVIEW
<div class="table-responsive">`import { InputComponent } from '@inail/intranet-webkit/form-controls';`</div>
Il componente InputComponent è un campo di input avanzato, progettato per garantire flessibilità, accessibilità e personalizzazione. Supporta funzionalità come la gestione dinamica delle validazioni con FormControl, il dimensionamento configurabile tramite opzioni Bootstrap e l'integrazione di tooltip contestuali per migliorare l'usabilità. Inoltre, offre strumenti per l'accessibilità, come il supporto per i lettori di schermo, e consente di personalizzare etichette e messaggi di errore per un'esperienza utente ottimale.


## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>maxlength</code></td>
      <td>
        `@Input() maxlength: any;` <br />
        Numero massimo di caratteri consentiti nell'input.
      </td>
    </tr>
    <tr>
      <td><code>BaseInputComponent controls</code></td>
      <td>
        `class InputComponent extends BaseInputComponent` <br />
        La classe `InputComponent` estende  <a href="?path=/docs/resources-models-baseinputcomponent--docs">BaseInputComponent</a>
      </td>
    </tr>
    <tr>
      <td><code>size</code></td>
      <td>
      `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
      La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
      </td>
    </tr>
  </tbody>
</table>
</div>