# ActionItem

Documentazione dettagliata dell'oggetto custom  **ActionItem**, usato nei componenti di Internet Webkit v17. 
**ActionItem** viene usato per costruire azioni custom tramite la struttura definita dal costruttore.

## Implementazione
<div class="table-responsive">`import { ActionItem } from '@inail/angular-core'`</div>
<br />

***Struttura:***
`constructor(
  name: string,
  action: (action: ActionItem, item: any, onComplete?: Function) => any,
  icon?: string | string[] | undefined,
  type: ActionItemType = 'NORMAL',
  auth?: string | Array<string>,
  disabled?: boolean,
  extra: ACTION_ITEM_EXTRA_OPTIONS = {},
)`

***Esempio d'uso:***
` action: new ActionItem(
   'BUTTON.DOWNLOAD_FILE', //name
   () => {}, //action
   'download' //icon
 )`

## API
<div class="table-responsive">
  <table class="table">
    <thead>
      <tr>
        <th><strong>Campo</strong></th>
        <th><strong>Descrizione</strong></th>
      </tr>
    </thead>
    <tbody>
    <tr>
      <td><code>name</code></td>
      <td>
        Campo di tipo string che definisce il nome della azione.
      </td>
    </tr>
    <tr>
      <td><code>action</code></td>
      <td>
        Campo che assegna una funzione all' ActionItem.
      </td>
    </tr>
    <tr>
      <td><code>icon</code></td>
      <td>
        Campo non obbligatorio. Può essere una stringa o un array di stringhe. Assegna un' icona all' azione.
      </td>
    </tr>
    <tr>
      <td><code>type</code></td>
      <td>
        Campo di tipo <code>ActionItemType</code> che definisce il tipo di azione. Il valore default è 'NORMAL', tra i possibili valori:
        <ul>
          <li>
            LINK
          </li>
          <li>
            NORMAL
          </li>
          <li>
            SECONDARY
          </li>
          <li>
            ICON
          </li>
        </ul>
      <code>type ActionItemType =  'LINK' | 'NORMAL' | 'SECONDARY' | 'ICON'</code>
      </td>
    </tr>
    <tr>
      <td><code>auth</code></td>
      <td>
        Campo non obbligatorio. Puo essere una stringa o array di stringhe.
      </td>
    </tr>
    <tr>
      <td><code>disabled</code></td>
      <td>
        Campo non obbligatorio. Booleano che disabilita l'azione.
      </td>
    </tr>
    <tr>
      <td><code>extra</code></td>
      <td>
        Campo di tipo <code>ACTION_ITEM_EXTRA_OPTIONS</code> che aggiunge attributi extra all' oggetto <code>ActionItem</code>.
        <code>interface ACTION_ITEM_EXTRA_OPTIONS { popoverTemplate?: any; popoverTitle?: string; }</code>
      </td>
    </tr>
  </tbody>
</table>
</div>

## Casi d'utilizzo
<br />
<a href="?path=/story/components-buttons-action--action">Action</a>
<br/>
<a href="?path=/story/components-buttons-actions-dropdown--actions-dropdown">Action Dropdown</a>
<br/>
<a href="?path=/story/components-elements-badge--badge">Badge</a>
<br/>
<a href="?path=/story/components-elements-feedback--feedback">Feedback</a>
<br/>
<a href="?path=/story/components-elements-sticky--sticky">Sticky</a>
<br/>
<a href="?path=/story/components-expandable-panel--expandable-panel">Expandable Panel</a>
<br/>
<a href="?path=/story/components-form-form-controls-checkbox--checkbox">Form Controls (tranne Date e Double Date)</a>
<br/>
<a href="?path=/story/components-modal-basic--basic-modal">Modal</a>
<br/>
<a href="?path=/story/components-table-paginated--table-pagination">Paginated Table</a>