## CARATTERISTICHE PRINCIPALI
Le funzionalità chiave del componente Simple Table includono:

* La possibilità di personalizzare l'aspetto della tabella attraverso la definizione di stili CSS
* L'inclusione di opzioni per la gestione dei dati, come ad esempio la possibilità di ordinare e filtrare le righe
* La capacità di integrarsi con altri componenti per creare interfacce utente più complesse

Gli aspetti tecnici rilevanti del componente Simple Table includono:

* L'utilizzo di HTML e CSS per la definizione della struttura e dell'aspetto della tabella
* La possibilità di utilizzare JavaScript per aggiungere funzionalità dinamiche alla tabella

Le caratteristiche di accessibilità del componente Simple Table includono:

* La conformità agli standard WAI-ARIA per l'accessibilità dei contenuti web
* La possibilità di personalizzare la tabella per soddisfare le esigenze degli utenti con disabilità

## VARIANTI
Le varianti disponibili del componente Simple Table includono:

* **Simple Table**: la variante base del componente, che consente di visualizzare dati in forma tabellare
* **Stories**: una variante che include storie e descrizioni per ogni riga della tabella

Per ogni variante, i casi d'uso specifici includono:

* Utilizzo come elemento di interfaccia utente per la visualizzazione dei dati
* Integrazione con altri componenti per creare interfacce utente più complesse

## BEST PRACTICES
Le raccomandazioni d'uso del componente Simple Table includono:

* Utilizzare il componente per la visualizzazione di dati in forma tabellare
* Personalizzare l'aspetto della tabella attraverso la definizione di stili CSS
* Integrare il componente con altri elementi per creare interfacce utente più complesse

Le linee guida implementative del componente Simple Table includono:

* Utilizzare HTML e CSS per la definizione della struttura e dell'aspetto della tabella
* Aggiungere funzionalità dinamiche alla tabella attraverso l'utilizzo di JavaScript

Le pratiche da evitare includono:

* Non utilizzare il componente per scopi diversi dalla visualizzazione dei dati in forma tabellare
* Non personalizzare eccessivamente l'aspetto della tabella, in modo da mantenere la sua leggibilità e accessibilità

## COMPONENTI CORRELATI
I componenti associati al Simple Table includono:

* **Button**: un componente che consente di aggiungere pulsanti alla tabella
* **Input**: un componente che consente di aggiungere campi di input alla tabella

Le relazioni con altri elementi includono:

* Integrazione con altri componenti per creare interfacce utente più complesse
* Utilizzo del componente come elemento di interfaccia utente per la visualizzazione dei dati

## OVERVIEW
<div class="table-responsive">`import { TableResultComponent } from '@inail/internet-webkit/tables';`</div>
Componente custom usato per costruire tabelle. In questo caso, basta usare solo parti del componente del webkit per costruire una variazione semplice della tabella.

## API
<div class="table-responsive">
  <table class="table">
  <tbody>
  <thead>
	<tr>
	  <th style="width: 20%"><strong>Campo</strong></th>
	  <th style="width: 80%"><strong>Descrizione</strong></th>
	</tr>
  </thead>
	<tr>
	  <td><code>title</code></td>
	  <td>
		  `@Input() title!: string;` <br />
		  Titolo visualizzato sopra la tabella.
	  </td>
	</tr>
	<tr>
	  <td><code>description</code></td>
	  <td>
		  `@Input() description!: string;` <br />
		  Descrizione della tabella mostrata sotto il titolo.
	  </td>
	</tr>
	<tr>
	  <td><code>results</code></td>
	  <td>
		  `@Input('results') set manageResultInput(result: any[]) {}` <br />
		  Un array di oggetti che vengono mostrati nella tabella come elementi. Per informazioni più approfondite fare riferimento alla documentazione di <a href="?path=/docs/resources-models-results--docs">results</a>
	  </td>
	</tr>
	<tr>
	  <td><code>structure</code></td>
	  <td>
		  `@Input('structure') tableStructure: any[] = [];` <br />
		  Un array che costruisce la struttura della tabella. L' array contiene elementi di tipo  <a href="?path=/docs/resources-models-tablefield--docs">TableField</a> che rappresentano le colonne, e facoltativamente, è possibile aggiungere un ultimo oggetto <a href="?path=/docs/resources-models-actionsfield--docs">ActionsField</a>  che rappresenta la colonna delle azioni della tabella.
			`const tableStructure = [
  			new TableField('Colonna 1', true, 'NORMAL', 'name', false),
  			new TableField('Colonna 2', false, 'NORMAL', 'size', false),
  			new ActionsField('', [
  			  new ActionItem(
  			    'BUTTON.EDIT_STEP',
  			    (actions: ActionItem, item: any) => {
  			      action('onEdit')('');
  			    },
  			    ['pencil']
  			  ),
  			]),
];`
	  </td>
	</tr>
	<tr>
	  <td><code>bordered</code></td>
	  <td>
		  `@Input() bordered: true;` <br />
		  Booleano utilizzato per mostrare/nascondere le divisioni delle righe e colonne della tabella.
	  </td>
	</tr>
	<tr>
	  <td><code>stripped</code></td>
	  <td>
		  `@Input() stripped: true;` <br />
		  Booleano utilizzato per applicare la classe CSS `table-striped`.
	  </td>
	</tr>
	<tr>
	  <td><code>bgWhite</code></td>
	  <td>
		  `@Input() bgWhite: true;` <br />
		  Booleano utilizzato per impostare un sfondo bianco quando impostato su `true` o transparente quando impostato su `false`.
	  </td>
	</tr>
	<tr>
	  <td><code>loading</code></td>
	  <td>
		  `@Input() loading: false;` <br />
		  Booleano utilizzato per mostrare uno stato di caricamento dei dati nella tabella.
	  </td>
	</tr>
	<tr>
	  <td><code>hover</code></td>
	  <td>
		  `@Input() hover: true;` <br />
		  Booleano utilizzato per abilitare l' effetto del passaggio del mouse sulle righe.
	  </td>
	</tr>
  </tbody>
</table>
</div>