## CARATTERISTICHE PRINCIPALI

* **Funzionalità chiave**: il componente consente la selezione di una sola opzione tra un elenco di possibilità.
* **Aspetti tecnici rilevanti**: il componente utilizza le proprietà HTML e CSS per gestire l'aspetto e il comportamento delle opzioni. La struttura del componente è definita da un oggetto JSON che contiene le informazioni relative alle opzioni.
* **Caratteristiche di accessibilità**: il componente è progettato per essere utilizzato con facilità anche dagli utenti con disabilità, grazie all'utilizzo di tecnologie assistive come i lettori di schermo.

## VARIANTI
Il componente Radio Table Form dispone di tre varianti:

* **Variante 1**: Test della descrizione del radio table form INAIL
 + Descrizione: questa variante è utilizzata per testare la funzionalità del componente.
 + Caso d'uso: viene utilizzato per verificare che il componente funzioni correttamente in diverse situazioni.
* **Variante 2**: Nome completo CONIUGE FIGLIO/A ALTRO Familiare 1 CONIUGE.FIGLIO/A.ALTRO. Familiare 2 CONIUGE.FIGLIO/A.ALTRO. Familiare 3 CONIUGE.FIGLIO/A.ALTRO.
 + Descrizione: questa variante è utilizzata per gestire un elenco di opzioni relative a informazioni personali.
 + Caso d'uso: viene utilizzato per raccogliere informazioni sugli utenti in diverse situazioni.

## BEST PRACTICES

* **Raccomandazioni d'uso**: il componente deve essere utilizzato in situazioni in cui è necessario effettuare scelte multiple tra un elenco di possibilità.
* **Linee guida implementative**: il componente deve essere personalizzato per adattarsi alle esigenze specifiche dell'applicazione.
* **Pratiche da evitare**: non utilizzare il componente in situazioni in cui è necessario effettuare scelte multiple tra un elenco di possibilità.

## COMPONENTI CORRELATI
Il componente Radio Table Form è associato ai seguenti componenti:

* N.D.

Nota: le informazioni relative ai componenti correlati non sono disponibili.

## OVERVIEW
<div class="table-responsive">`import { RadioTableFormComponent } from '@inail/internet-webkit/form-controls';`</div>

Il componente `RadioTableFormComponent` viene utilizzato per creare una tabella con opzioni radio button, consentendo agli utenti di selezionare un'opzione per ogni riga. Supporta la configurazione dinamica della struttura della tabella e delle dimensioni della griglia, offrendo flessibilità nella personalizzazione. 

## API
<div class="table-responsive">
  <table class="table">
   <thead>
      <tr>
         <th><strong>Campo</strong></th>
         <th><strong>Descrizione</strong></th>
      </tr>
   </thead>
   <tbody>
      <tr>
         <td><code>tableSize</code></td>
         <td>
            `@Input tableSize: string | BootstrapSize;` <br />
            Specifica le dimensioni della tabella utilizzando valori di Bootstrap o stringhe predefinite. 
            Se non specificato, il valore predefinito è `'12|12|12|12'`.         </td>
      </tr>
      <tr>
         <td><code>id</code></td>
         <td>
            `@Input() id = composeUniqueId('radio_table_form');` <br />
            Identificatore univoco.
         </td>
      </tr>
       <tr>
         <td><code>description</code></td>
         <td>
            `@Input() description!: string;` <br />
            Una descrizione che fornisce informazioni aggiuntive sull'uso della tabella.
         </td>
      </tr>
       <tr>
         <td><code>tableFormStructure</code></td>
         <td>
            `@Input() tableFormStructure: RadioTableFormStructure;` <br />
            Struttura che definisce le form headers della tabella e i form fields.
         </td>
      </tr>
   </tbody>
</table>
</div>