## CARATTERISTICHE PRINCIPALI
Le funzionalità chiave del componente Input Label sono:

* **Label**: il testo che viene visualizzato come etichetta del campo di input.
* **srOnly**: un flag che indica se l'etichetta deve essere visualizzata solo per gli screen reader
* **asteriskReplacedToSR**: un flag che indica se sostituire l'asterisco con un messaggio di errore personalizzato

Gli aspetti tecnici rilevanti del componente Input Label sono:

* Il componente utilizza una struttura HTML standard per la visualizzazione dell'etichetta
* Il componente supporta l'utilizzo di attributi HTML per la personalizzazione della visualizzazione

Le caratteristiche di accessibilità del componente Input Label sono:

* Il componente è progettato per essere compatibile con gli screen reader
* Il componente fornisce una descrizione chiara e concisa del campo di input per gli utenti con disabilità visive

## VARIANTI
Le varianti disponibili per il componente Input Label sono:

* **InputLabel**: la variante standard del componente
* **InputLabel with srOnly**: la variante che visualizza l'etichetta solo per gli screen reader
* **InputLabel with asteriskReplacedToSR**: la variante che sostituisce l'asterisco con un messaggio di errore personalizzato

I casi d'uso specifici per ogni variante sono:

* **InputLabel**: utilizzare quando si desidera visualizzare un'etichetta standard per il campo di input
* **InputLabel with srOnly**: utilizzare quando si desidera visualizzare l'etichetta solo per gli screen reader
* **InputLabel with asteriskReplacedToSR**: utilizzare quando si desidera sostituire l'asterisco con un messaggio di errore personalizzato

## BEST PRACTICES
Le raccomandazioni d'uso per il componente Input Label sono:

* Utilizzare il componente per fornire una descrizione chiara e concisa del campo di input
* Personalizzare la visualizzazione dell'etichetta utilizzando gli attributi HTML disponibili
* Testare il componente con diversi browser e dispositivi per garantirne la compatibilità

Le linee guida implementative per il componente Input Label sono:

* Utilizzare una struttura HTML standard per la visualizzazione dell'etichetta
* Supportare l'utilizzo di attributi HTML per la personalizzazione della visualizzazione

Le pratiche da evitare per il componente Input Label sono:

* Non utilizzare il componente come un semplice elemento di testo, ma come un componente funzionale che fornisce una descrizione chiara e concisa del campo di input.

## COMPONENTI CORRELATI
I componenti associati al componente Input Label sono:

* **Campo di input**: il componente che viene utilizzato per raccogliere l'input dell'utente
* **Messaggio di errore**: il componente che viene utilizzato per visualizzare un messaggio di errore personalizzato

Le relazioni con altri elementi del sistema sono:

* Il componente Input Label è utilizzato in combinazione con il campo di input e il messaggio di errore per fornire una esperienza utente completa e funzionale.

## OVERVIEW
<div class="table-responsive">`import { InputLabelComponent } from '@inail/internet-webkit/form-controls';`</div>


Il componente InputLabelComponent viene utilizzato per creare un'etichetta personalizzabile associata a un campo di input, con supporto per tooltip e opzioni di accessibilità avanzate, come la visibilità esclusiva per gli screen reader. Inoltre, consente di indicare se il campo è obbligatorio e di gestire messaggi specifici per migliorare l'usabilità.


## API
<div class="table-responsive">
  <table class="table">
   <thead>
      <tr>
         <th><strong>Campo</strong></th>
         <th><strong>Descrizione</strong></th>
      </tr>
   </thead>
   <tbody>
      <tr>
         <td><code>inailInputLabel</code></td>
         <td>
            `@Input('inailInputLabel') label!: string;` <br />
            Etichetta del campo di input.
         </td>
      </tr>
      <tr>
         <td><code>srOnly</code></td>
         <td>
            `@Input() srOnly!: boolean;` <br />
            Specifica se l'etichetta è visibile solo agli screen reader.
         </td>
      </tr>
      <tr>
         <td><code>inputId</code></td>
         <td>
            `@Input() inputId!: string;` <br />
            L'ID dell' input.
         </td>
      </tr>
      <tr>
         <td><code>required</code></td>
         <td>
            `@Input() required!: boolean;` <br />
            Specifica se il campo è obbligatorio.
         </td>
      </tr>
      <tr>
         <td><code>asteriskReplacedToSR</code></td>
         <td>
            `@Input() asteriskReplacedToSR = true;` <br />
           Sostituisce l'asterisco nell' etichetta con il messaggio 'ERROR.REQUIRED'.
         </td>
      </tr>
         <tr>
         <td><code>tooltip</code></td>
         <td>
            `@Input() tooltip!: TooltipModel;` <br />
           Oggetto <a href = "?path=/docs/resources-models-tooltipmodel--docs">Tooltip</a>  del campo di input.
         </td>
      </tr>
   </tbody>
</table>
</div>