## CARATTERISTICHE PRINCIPALI

Le funzionalità chiave del componente Multiple Select sono:

* **Selezione multipla**: gli utenti possono selezionare più opzioni da una lista
* **Gestione delle opzioni**: le opzioni possono essere gestite attraverso un'interfaccia utente intuitiva
* **Personalizzazione**: l'aspetto e il comportamento del componente possono essere personalizzati

Gli aspetti tecnici rilevanti sono:

* Il componente è realizzato utilizzando tecnologie web standard (HTML, CSS, JavaScript)
* Il componente può essere integrato con altre librerie e framework di sviluppo web

Le caratteristiche di accessibilità sono:

* Il componente è progettato per essere accessibile agli utenti con disabilità
* Il componente rispetta le linee guida di accessibilità WCAG 2.1

## VARIANTI

Le varianti del componente Multiple Select sono:

* **Variante 1**: una variante di base che fornisce la funzionalità di selezione multipla
* **Variante 2**: una variante che aggiunge la possibilità di filtrare le opzioni
* **Variante 3**: una variante che aggiunge la possibilità di ordinare le opzioni

I casi d'uso specifici per ogni variante sono:

* Variante 1: utilizzare il componente per fornire una forma semplice di selezione multipla
* Variante 2: utilizzare il componente per fornire una forma più avanzata di selezione multipla con filtraggio delle opzioni
* Variante 3: utilizzare il componente per fornire una forma più avanzata di selezione multipla con ordinamento delle opzioni

## BEST PRACTICES

Le raccomandazioni d'uso sono:

* Utilizzare il componente in contesti dove è necessaria la selezione multipla di opzioni
* Personalizzare l'aspetto e il comportamento del componente per adattarlo alle esigenze dell'applicazione
* Testare il componente per garantire la sua accessibilità e funzionalità

Le linee guida implementative sono:

* Utilizzare tecnologie web standard per realizzare il componente
* Seguire le linee guida di accessibilità WCAG 2.1

Le pratiche da evitare sono:

* Non utilizzare il componente in contesti dove non è necessaria la selezione multipla di opzioni
* Non personalizzare eccessivamente l'aspetto e il comportamento del componente, altrimenti potrebbe diventare difficile da usare

## COMPONENTI CORRELATI

I componenti associati sono:

* **Select**: un componente di selezione singola che può essere utilizzato in combinazione con il Multiple Select
* **Checkbox**: un componente di selezione multipla che può essere utilizzato come alternativa al Multiple Select

Le relazioni con altri elementi sono:

* Il componente Multiple Select può essere utilizzato all'interno di formulari e liste per fornire una forma flessibile di selezione multipla.


## OVERVIEW
<div class="table-responsive">`import { MultipleSelectComponent } from '@inail/internet-webkit/form-controls';`</div>

Il componente MultipleSelectComponent consente agli utenti di selezionare più opzioni da un elenco predefinito, con funzionalità di ricerca e filtro. Il componente permette di visualizzare un elenco di opzioni che possono essere filtrate dinamicamente tramite una ricerca live.Le opzioni per la selezione sono passate come array di oggetti e possono essere recuperate anche tramite un Observable, consentendo di gestire dati remoti in modo dinamico. Il componente offre inoltre la possibilità di aggiungere messaggi di supporto e di avviso sotto il campo di input.


## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>field-for-id</code></td>
      <td>
        `@Input('field-for-id') fieldForId!: string;` <br />
        Nome del campo utilizzato come ID univoco per ciascuna opzione.
      </td>
    </tr>
    <tr>
      <td><code>field-for-option</code></td>
      <td>
        `@Input('field-for-option') fieldForOptionElement = 'descrizione';` <br />
        Nome del campo utilizzato per visualizzare l'etichetta di ciascuna opzione.
      </td>
    </tr>
    <tr>
      <td><code>filtrable</code></td>
      <td>
        `@Input() filtrable = false;` <br />
        Abilita il filtraggio all'interno delle opzioni di selezione multipla.
      </td>
    </tr>
    <tr>
      <td><code>liveSearchStyle</code></td>
      <td>
        `@Input() liveSearchStyle: MultipleSelectLiveSearchStyle = 'contains';` <br />
        Determina lo stile di filtraggio per la ricerca: "contiene" o "startsWith". <br />
        Oggetto di tipo <a href="?path=/docs/resources-models-multipleselectlivesearchstyle--docs">MultipleSelectLiveSearchStyle</a>.
      </td>
    </tr>
    <tr>
      <td><code>selectElementToDisplay</code></td>
      <td>
        `@Input() selectElementToDisplay = 5;` <br />
        Il numero massimo di opzioni visualizzate per impostazione predefinita
      </td>
    </tr>
    <tr>
      <td><code>selectAllCheckbox</code></td>
      <td>
        `@Input() selectAllCheckbox = false;` <br />
       Aggiunge un checkbox 'Select All' in cima all'elenco delle opzioni.
      </td>
    </tr>
    <tr>
      <td><code>allCheckboxLabel</code></td>
      <td>
        `@Input() allCheckboxLabel = 'LABEL.SELECT_ALL_CHECKBOX';` <br />
        Testo dell'etichetta per la casella di controllo 'Select All'
      </td>
    </tr>
    <tr>
      <td><code>readOnlyIfListIsEmpty</code></td>
      <td>
        `@Input() readOnlyIfListIsEmpty = false;` <br />
        Disabilita la selezione se l'elenco delle opzioni è vuoto.
      </td>
    </tr>
    <tr>
      <td><code>maxDigits</code></td>
      <td>
        `@Input() maxDigits = 0;` <br />
        Il numero massimo di cifre consentito.
      </td>
    </tr>
    <tr>
      <td><code>options</code></td>
      <td>
        `@Input() options: Array<any>;` <br />
        Oggetto di tipo <a href="?path=/docs/resources-models-options--docs">Options</a>. L'oggetto opzioni viene utilizzato in MultiSelect.
      </td>
    </tr>
    <tr>
      <td><code>remote</code></td>
      <td>
        `@Input() remote!: (param: any) => Observable<any[]>;` <br />
        La funzione remote viene utilizzata in MultiSelectRemote. Questa funzione likeOptions viene passata come input remoto, dove viene utilizzata per fornire dati filtrati ogni volta che sono necessari (ad esempio, durante operazioni di ricerca o filtro).
        `let likeOptions = (term: string): Observable<any[]> => {
           return of(
               selectDatasource.filter((el) =>
               el.descrizione.toLowerCase().includes(term.toLowerCase())
            ));`
      </td>
    </tr>
    <tr>
      <td><code>BaseInputComponent controls</code></td>
      <td>
        `class InputComboboxComponent extends BaseInputComponent` <br />
        Fare riferimento a <a href="?path=/docs/resources-models-baseinputcomponent--docs">BaseInputComponent</a>
      </td>
    </tr>
      <tr>
        <td><code>size</code></td>
        <td>
        `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
        La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
        </td>
      </tr>

  </tbody>
</table>
</div>