/*$(document).ready(function() {
            const $input = $('#combobox-input');
            const $options = $('#combobox-options');
            const $optionElements = $options.find('.option');

            $input.on('input', function() {
                filter = $input.val().toLowerCase();
                let hasVisibleOptions = false;
                $optionElements.each(function() {
                    const $option = $(this);
                    if ($option.text().toLowerCase().includes(filter)) {
                        $option.show();
                        hasVisibleOptions = true;
                    } else {
                        $option.hide();
                    }
                });
                $options.css('display', hasVisibleOptions ? 'block' : 'none');
            });

            $input.on('focus', function() {
                if ($input.val()) {
                    $options.show();
                }
            });

            $input.on('blur', function() {
                setTimeout(function() {
                    if (!$.contains($options[0], document.activeElement)) {
                        $options.hide();
                    }
                }, 100);
            });

            $optionElements.on('click', function() {
                $input.val($(this).text());
                $options.hide();
            });

            $optionElements.on('keydown', function(e) {
                if (e.key === 'Enter') {
                    $input.val($(this).text());
                    $options.hide();
                }
            });

            $input.on('keydown', function(e) {
                if (e.key === 'ArrowDown') {
                    const $visibleOptions = $optionElements.filter(':visible');
                    if ($visibleOptions.length > 0) {
                        $visibleOptions.first().focus();
                    }
                } else if (e.key === 'Escape') {
                    $options.hide();
                }
            });

            $options.on('keydown', function(e) {
                const $visibleOptions = $optionElements.filter(':visible');
                const $focusedElement = $(document.activeElement);
                const index = $visibleOptions.index($focusedElement);

                if (e.key === 'ArrowDown') {
                    const $nextElement = $visibleOptions.eq(index + 1);
                    if ($nextElement.length) {
                        $nextElement.focus();
                    }
                } else if (e.key === 'ArrowUp') {
                    const $previousElement = $visibleOptions.eq(index - 1);
                    if ($previousElement.length) {
                        $previousElement.focus();
                    }
                } else if (e.key === 'Escape') {
                    $options.hide();
                    $input.focus();
                }
            });
        }); */

$(document).ready(function() {
    const $input = $('#combobox-input');
    const $options = $('#combobox-options');
    const $optionElements = $options.find('.option');
    let currentFilter = '';
    let isKeyboardNavigation = false;

    // Filtra le opzioni
    function filterOptions(filter) {
        currentFilter = filter.toLowerCase();
        let hasMatches = false;
        
        $optionElements.each(function() {
            const $option = $(this);
            const isMatch = $option.text().toLowerCase().includes(currentFilter);
            $option.toggle(isMatch);
            hasMatches = hasMatches || isMatch;
        });
        
        $options.toggle(hasMatches && currentFilter !== '');
    }

    // Gestione eventi input
    $input.on('input', function() {
        filterOptions($(this).val());
    }).on('focus', function() {
        if ($input.val().trim() !== '') {
            filterOptions($input.val());
        }
    }).on('keydown', function(e) {
        if (e.key === 'ArrowDown') {
            e.preventDefault();
            isKeyboardNavigation = true;
            const $visible = $optionElements.filter(':visible');
            if ($visible.length) $visible.first().focus();
        } else if (e.key === 'Enter') {
            e.preventDefault();
            $options.show();
        }
    }).on('blur', function() {
        if (!isKeyboardNavigation) {
            setTimeout(() => $options.hide(), 100);
        }
    });

    // Gestione eventi opzioni
    $optionElements.on('click', function() {
        if ($(this).text() != '- seleziona opzione -') {
            $input.val($(this).text()).focus();
        } else {
            $input.val('').focus();
        }
        $options.hide();
    }).on('keydown', function(e) {
        const $visible = $optionElements.filter(':visible');
        const currentIndex = $visible.index(this);

        if (e.key === 'Enter') {
            if ($(this).text() != '- seleziona opzione -') {
                $input.val($(this).text()).focus();
            } else {
                $input.val('').focus();
            }
            $options.hide();
        } else if (e.key === 'ArrowDown') {
            e.preventDefault();
            $visible.eq(currentIndex + 1).focus();
        } else if (e.key === 'ArrowUp') {
            e.preventDefault();
            currentIndex <= 0 ? $input.focus() : $visible.eq(currentIndex - 1).focus();
        } else if (e.key === 'Escape') {
            $input.focus();
        }
    });

    // Blocca la chiusura durante la navigazione
    $options.on('mouseenter', () => isKeyboardNavigation = false)
           .on('keydown', () => isKeyboardNavigation = true);
});