## CARATTERISTICHE PRINCIPALI
Le caratteristiche chiave del componente Selettore sono:

* Funzionalità di selezione: il componente consente all'utente di selezionare una opzione da un elenco di possibilità
* Aspetti tecnici rilevanti: il componente utilizza la proprietà `propertyName` per gestire le opzioni e la proprietà `summary` per visualizzare la descrizione dell'opzione selezionata
* Caratteristiche di accessibilità: il componente è progettato per essere accessibile anche per gli utenti con disabilità, grazie alla possibilità di utilizzare la tastiera per navigare tra le opzioni

## VARIANTI
Le varianti del componente Selettore sono:

* **Test della descrizione del Select**: una variante che visualizza un elenco di opzioni con descrizioni dettagliate
	+ Caso d'uso: utilizzare questa variante quando è necessario fornire all'utente ulteriori informazioni sulle opzioni disponibili
	+ Breve descrizione: "Visualizzazione di un elenco di opzioni con descrizioni dettagliate"
* **INAIL Select**: una variante che visualizza un elenco di opzioni relative all'INAIL (Istituto Nazionale per l'Assicurazione contro gli Infortuni sul Lavoro)
	+ Caso d'uso: utilizzare questa variante quando è necessario fornire all'utente opzioni relative all'INAIL
	+ Breve descrizione: "Visualizzazione di un elenco di opzioni relative all'INAIL"
* **Select**: una variante che visualizza un elenco di opzioni generiche
	+ Caso d'uso: utilizzare questa variante quando è necessario fornire all'utente un elenco di opzioni generiche
	+ Breve descrizione: "Visualizzazione di un elenco di opzioni generiche"

## BEST PRACTICES
Le raccomandazioni per l'utilizzo del componente Selettore sono:

* Utilizzare il componente quando è necessario fornire all'utente un elenco di opzioni da cui scegliere
* Fornire descrizioni dettagliate delle opzioni disponibili per aiutare l'utente a prendere una decisione informata
* Utilizzare la proprietà `propertyName` per gestire le opzioni e la proprietà `summary` per visualizzare la descrizione dell'opzione selezionata

## COMPONENTI CORRELATI
Il componente Selettore è correlato ai seguenti componenti:

* **Campo di testo**: un componente che consente all'utente di inserire del testo
* **Pulsante**: un componente che consente all'utente di eseguire un'azione

## OVERVIEW
<div class="table-responsive">`import { SelectComponent } from '@inail/intranet-webkit/form-controls';`</div>

Il componente Select Field è progettato per offrire una soluzione intuitiva e accessibile per selezionare un'unica opzione tra un gruppo predefinito. Ideale per situazioni in cui le scelte sono reciprocamente esclusive.

## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>field-for-id</code></td>
      <td>
        `@Input('field-for-id') fieldForId: string | undefined;` <br />
        Specificare il nome del campo per estrarre il valore per il form control.
      </td>
    </tr>
    <tr>
      <td><code>field-for-option</code></td>
      <td>
        `@Input('field-for-option') fieldForOptionElement = 'descrizione';` <br />
        Il nome del campo utilizzato per l'etichetta di ciascuna opzione del select.
      </td>
    </tr>
    <tr>
      <td><code>options</code></td>
      <td>
        `@Input() options(options: any[])` <br />
		 Array di opzioni disponibili per la selezione.
      </td>
    </tr>
    <tr>
      <td><code>disabledOptions</code></td>
      <td>
        `@Input() disabledOptions(value: any[])` <br />
		 Array di opzioni che dovrebbero essere disabilitate.
      </td>
    </tr>
    <tr>
      <td><code>readOnlyIfListIsEmpty</code></td>
      <td>
        `@Input() readOnlyIfListIsEmpty = false;` <br />
		 Disabilita la selezione se l'elenco delle opzioni è vuoto.
      </td>
    </tr>
    <tr>
      <td><code>inline</code></td>
      <td>
        `@Input() inline = false;` <br />
		 Determina se il componente deve essere visualizzato in un layout inline all'interno del suo elemento padre.
      </td>
    </tr>
    <tr>
      <td><code>BaseInputComponent controls</code></td>
      <td>
        `class SelectComponent extends BaseInputComponent` <br />
        La classe `SelectComponent` estende <a href="?path=/docs/resources-models-baseinputcomponent--docs">BaseInputComponent.</a>
      </td>
    </tr>
    <tr>
      <td><code>size</code></td>
      <td>
       `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
        La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
      </td>
    </tr>
  </tbody>
</table>
</div>